/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.RequestPayer;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class UploadPartRequest {
    byte[] body;
    String bucket;
    Long contentLength;
    String contentMD5;
    String key;
    Integer partNumber;
    String uploadId;
    String sSECustomerAlgorithm;
    String sSECustomerKey;
    String sSECustomerKeyMD5;
    RequestPayer requestPayer;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    UploadPartRequest() {
        this.body = null;
        this.bucket = "";
        this.contentLength = null;
        this.contentMD5 = "";
        this.key = "";
        this.partNumber = null;
        this.uploadId = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKey = "";
        this.sSECustomerKeyMD5 = "";
        this.requestPayer = null;
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected UploadPartRequest(BuilderImpl builder) {
        this.body = builder.body;
        this.bucket = builder.bucket;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKey = builder.sSECustomerKey;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(UploadPartRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof UploadPartRequest;
    }

    public byte[] body() {
        return this.body;
    }

    public String bucket() {
        return this.bucket;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String key() {
        return this.key;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKey() {
        return this.sSECustomerKey;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        byte[] body;
        String bucket;
        Long contentLength;
        String contentMD5;
        String key;
        Integer partNumber;
        String uploadId;
        String sSECustomerAlgorithm;
        String sSECustomerKey;
        String sSECustomerKeyMD5;
        RequestPayer requestPayer;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(UploadPartRequest model) {
            this.body(model.body);
            this.bucket(model.bucket);
            this.contentLength(model.contentLength);
            this.contentMD5(model.contentMD5);
            this.key(model.key);
            this.partNumber(model.partNumber);
            this.uploadId(model.uploadId);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKey(model.sSECustomerKey);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }

        @Override
        public final Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKey(String sSECustomerKey) {
            this.sSECustomerKey = sSECustomerKey;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public byte[] body() {
            return this.body;
        }

        public String bucket() {
            return this.bucket;
        }

        public Long contentLength() {
            return this.contentLength;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String key() {
            return this.key;
        }

        public Integer partNumber() {
            return this.partNumber;
        }

        public String uploadId() {
            return this.uploadId;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKey() {
            return this.sSECustomerKey;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder body(byte[] var1);

        public Builder bucket(String var1);

        public Builder contentLength(Long var1);

        public Builder contentMD5(String var1);

        public Builder key(String var1);

        public Builder partNumber(Integer var1);

        public Builder uploadId(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKey(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public UploadPartRequest build();
    }
}

