/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.CSVInput;
import com.amazonaws.s3.model.CompressionType;
import com.amazonaws.s3.model.JSONInput;
import com.amazonaws.s3.model.ParquetInput;
import java.util.Objects;

public class InputSerialization {
    CSVInput cSV;
    CompressionType compressionType;
    JSONInput jSON;
    ParquetInput parquet;

    InputSerialization() {
        this.cSV = null;
        this.compressionType = null;
        this.jSON = null;
        this.parquet = null;
    }

    protected InputSerialization(BuilderImpl builder) {
        this.cSV = builder.cSV;
        this.compressionType = builder.compressionType;
        this.jSON = builder.jSON;
        this.parquet = builder.parquet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(InputSerialization.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof InputSerialization;
    }

    public CSVInput cSV() {
        return this.cSV;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public JSONInput jSON() {
        return this.jSON;
    }

    public ParquetInput parquet() {
        return this.parquet;
    }

    protected static class BuilderImpl
    implements Builder {
        CSVInput cSV;
        CompressionType compressionType;
        JSONInput jSON;
        ParquetInput parquet;

        protected BuilderImpl() {
        }

        private BuilderImpl(InputSerialization model) {
            this.cSV(model.cSV);
            this.compressionType(model.compressionType);
            this.jSON(model.jSON);
            this.parquet(model.parquet);
        }

        @Override
        public InputSerialization build() {
            return new InputSerialization(this);
        }

        @Override
        public final Builder cSV(CSVInput cSV) {
            this.cSV = cSV;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder jSON(JSONInput jSON) {
            this.jSON = jSON;
            return this;
        }

        @Override
        public final Builder parquet(ParquetInput parquet) {
            this.parquet = parquet;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public CSVInput cSV() {
            return this.cSV;
        }

        public CompressionType compressionType() {
            return this.compressionType;
        }

        public JSONInput jSON() {
            return this.jSON;
        }

        public ParquetInput parquet() {
            return this.parquet;
        }
    }

    public static interface Builder {
        public Builder cSV(CSVInput var1);

        public Builder compressionType(CompressionType var1);

        public Builder jSON(JSONInput var1);

        public Builder parquet(ParquetInput var1);

        public InputSerialization build();
    }
}

