/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.FileHeaderInfo;
import java.util.Objects;

public class CSVInput {
    FileHeaderInfo fileHeaderInfo;
    String comments;
    String quoteEscapeCharacter;
    String recordDelimiter;
    String fieldDelimiter;
    String quoteCharacter;
    Boolean allowQuotedRecordDelimiter;

    CSVInput() {
        this.fileHeaderInfo = null;
        this.comments = "";
        this.quoteEscapeCharacter = "";
        this.recordDelimiter = "";
        this.fieldDelimiter = "";
        this.quoteCharacter = "";
        this.allowQuotedRecordDelimiter = null;
    }

    protected CSVInput(BuilderImpl builder) {
        this.fileHeaderInfo = builder.fileHeaderInfo;
        this.comments = builder.comments;
        this.quoteEscapeCharacter = builder.quoteEscapeCharacter;
        this.recordDelimiter = builder.recordDelimiter;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.quoteCharacter = builder.quoteCharacter;
        this.allowQuotedRecordDelimiter = builder.allowQuotedRecordDelimiter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(CSVInput.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof CSVInput;
    }

    public FileHeaderInfo fileHeaderInfo() {
        return this.fileHeaderInfo;
    }

    public String comments() {
        return this.comments;
    }

    public String quoteEscapeCharacter() {
        return this.quoteEscapeCharacter;
    }

    public String recordDelimiter() {
        return this.recordDelimiter;
    }

    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String quoteCharacter() {
        return this.quoteCharacter;
    }

    public Boolean allowQuotedRecordDelimiter() {
        return this.allowQuotedRecordDelimiter;
    }

    protected static class BuilderImpl
    implements Builder {
        FileHeaderInfo fileHeaderInfo;
        String comments;
        String quoteEscapeCharacter;
        String recordDelimiter;
        String fieldDelimiter;
        String quoteCharacter;
        Boolean allowQuotedRecordDelimiter;

        protected BuilderImpl() {
        }

        private BuilderImpl(CSVInput model) {
            this.fileHeaderInfo(model.fileHeaderInfo);
            this.comments(model.comments);
            this.quoteEscapeCharacter(model.quoteEscapeCharacter);
            this.recordDelimiter(model.recordDelimiter);
            this.fieldDelimiter(model.fieldDelimiter);
            this.quoteCharacter(model.quoteCharacter);
            this.allowQuotedRecordDelimiter(model.allowQuotedRecordDelimiter);
        }

        @Override
        public CSVInput build() {
            return new CSVInput(this);
        }

        @Override
        public final Builder fileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
            this.fileHeaderInfo = fileHeaderInfo;
            return this;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public final Builder quoteEscapeCharacter(String quoteEscapeCharacter) {
            this.quoteEscapeCharacter = quoteEscapeCharacter;
            return this;
        }

        @Override
        public final Builder recordDelimiter(String recordDelimiter) {
            this.recordDelimiter = recordDelimiter;
            return this;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        @Override
        public final Builder quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        @Override
        public final Builder allowQuotedRecordDelimiter(Boolean allowQuotedRecordDelimiter) {
            this.allowQuotedRecordDelimiter = allowQuotedRecordDelimiter;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public FileHeaderInfo fileHeaderInfo() {
            return this.fileHeaderInfo;
        }

        public String comments() {
            return this.comments;
        }

        public String quoteEscapeCharacter() {
            return this.quoteEscapeCharacter;
        }

        public String recordDelimiter() {
            return this.recordDelimiter;
        }

        public String fieldDelimiter() {
            return this.fieldDelimiter;
        }

        public String quoteCharacter() {
            return this.quoteCharacter;
        }

        public Boolean allowQuotedRecordDelimiter() {
            return this.allowQuotedRecordDelimiter;
        }
    }

    public static interface Builder {
        public Builder fileHeaderInfo(FileHeaderInfo var1);

        public Builder comments(String var1);

        public Builder quoteEscapeCharacter(String var1);

        public Builder recordDelimiter(String var1);

        public Builder fieldDelimiter(String var1);

        public Builder quoteCharacter(String var1);

        public Builder allowQuotedRecordDelimiter(Boolean var1);

        public CSVInput build();
    }
}

