/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.AnalyticsFilter;
import com.amazonaws.s3.model.StorageClassAnalysis;
import java.util.Objects;

public class AnalyticsConfiguration {
    String id;
    AnalyticsFilter filter;
    StorageClassAnalysis storageClassAnalysis;

    AnalyticsConfiguration() {
        this.id = "";
        this.filter = null;
        this.storageClassAnalysis = null;
    }

    protected AnalyticsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
        this.storageClassAnalysis = builder.storageClassAnalysis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(AnalyticsConfiguration.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof AnalyticsConfiguration;
    }

    public String id() {
        return this.id;
    }

    public AnalyticsFilter filter() {
        return this.filter;
    }

    public StorageClassAnalysis storageClassAnalysis() {
        return this.storageClassAnalysis;
    }

    protected static class BuilderImpl
    implements Builder {
        String id;
        AnalyticsFilter filter;
        StorageClassAnalysis storageClassAnalysis;

        protected BuilderImpl() {
        }

        private BuilderImpl(AnalyticsConfiguration model) {
            this.id(model.id);
            this.filter(model.filter);
            this.storageClassAnalysis(model.storageClassAnalysis);
        }

        @Override
        public AnalyticsConfiguration build() {
            return new AnalyticsConfiguration(this);
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder filter(AnalyticsFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder storageClassAnalysis(StorageClassAnalysis storageClassAnalysis) {
            this.storageClassAnalysis = storageClassAnalysis;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String id() {
            return this.id;
        }

        public AnalyticsFilter filter() {
            return this.filter;
        }

        public StorageClassAnalysis storageClassAnalysis() {
            return this.storageClassAnalysis;
        }
    }

    public static interface Builder {
        public Builder id(String var1);

        public Builder filter(AnalyticsFilter var1);

        public Builder storageClassAnalysis(StorageClassAnalysis var1);

        public AnalyticsConfiguration build();
    }
}

