/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3;

import java.util.Objects;

public class S3Exception
extends RuntimeException {
    String message;
    String requestId;
    int statusCode;
    Throwable cause;

    protected S3Exception(BuilderImpl builder) {
        this.message = builder.message;
        this.requestId = builder.requestId;
        this.statusCode = builder.statusCode;
        this.cause = builder.cause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(S3Exception.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof S3Exception;
    }

    public String message() {
        return this.message;
    }

    public String requestId() {
        return this.requestId;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Throwable cause() {
        return this.cause;
    }

    protected static class BuilderImpl
    implements Builder {
        String message;
        String requestId;
        int statusCode;
        Throwable cause;

        protected BuilderImpl() {
        }

        private BuilderImpl(S3Exception model) {
            this.message(model.message);
            this.requestId(model.requestId);
            this.statusCode(model.statusCode);
            this.cause(model.cause);
        }

        @Override
        public S3Exception build() {
            return new S3Exception(this);
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public final Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String message() {
            return this.message;
        }

        public String requestId() {
            return this.requestId;
        }

        public int statusCode() {
            return this.statusCode;
        }

        public Throwable cause() {
            return this.cause;
        }
    }

    public static interface Builder {
        public Builder message(String var1);

        public Builder requestId(String var1);

        public Builder statusCode(int var1);

        public Builder cause(Throwable var1);

        public S3Exception build();
    }
}

