/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.support.AbstractSynchronizedCacheStrategyDecorator;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.change.ResourceWatcher;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.SchedulerHelper;

public class DefaultSynchronizedCacheStrategyDecorator
extends AbstractSynchronizedCacheStrategyDecorator<CacheKey, CacheValue> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSynchronizedCacheStrategyDecorator.class);
    @Inject
    private GroupsProcessor groupsProcessor;
    @Inject
    private HashStrategy hashStrategy;
    @Inject
    private ResourceAuthorizationManager authorizationManager;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private ResourceWatcher resourceWatcher;
    private final Set<CacheKey> checkedKeys = Collections.synchronizedSet(new HashSet());
    private final SchedulerHelper resourceWatcherScheduler = this.newResourceWatcherScheduler();

    public static CacheStrategy<CacheKey, CacheValue> decorate(CacheStrategy<CacheKey, CacheValue> decorated) {
        return decorated instanceof DefaultSynchronizedCacheStrategyDecorator ? decorated : new DefaultSynchronizedCacheStrategyDecorator(decorated);
    }

    private static CacheKey createIgnoreMinimizeFlagKey(CacheKey cacheKey) {
        return new CacheKey(cacheKey.getGroupName(), cacheKey.getType());
    }

    DefaultSynchronizedCacheStrategyDecorator(CacheStrategy<CacheKey, CacheValue> cacheStrategy) {
        super(cacheStrategy);
    }

    SchedulerHelper newResourceWatcherScheduler() {
        return SchedulerHelper.create(new LazyInitializer<Runnable>(){

            @Override
            protected Runnable initialize() {
                return new Runnable(){

                    @Override
                    public void run() {
                        DefaultSynchronizedCacheStrategyDecorator.this.checkedKeys.clear();
                    }
                };
            }
        }, "resourceWatcherScheduler");
    }

    @Override
    protected CacheValue loadValue(CacheKey key) {
        this.resourceWatcherScheduler.scheduleWithPeriod(this.getResourceWatcherUpdatePeriod(), this.getTimeUnitForResourceWatcher());
        LOG.debug("load value in cache for key: {}", (Object)key);
        String content = this.groupsProcessor.process(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug("found content: {}", (Object)StringUtils.abbreviate((String)content, (int)30));
        }
        return this.computeCacheValueByContent(content);
    }

    private long getResourceWatcherUpdatePeriod() {
        return this.context.getConfig().getResourceWatcherUpdatePeriod();
    }

    TimeUnit getTimeUnitForResourceWatcher() {
        return TimeUnit.SECONDS;
    }

    private CacheValue computeCacheValueByContent(String content) {
        String hash = null;
        try {
            if (content != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content to fingerprint: [{}]", (Object)StringUtils.abbreviate((String)content, (int)30));
                }
                hash = this.hashStrategy.getHash(new ByteArrayInputStream(content.getBytes()));
            }
            CacheValue entry = CacheValue.valueOf(content, hash);
            LOG.debug("computed entry: {}", (Object)entry);
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    @Override
    protected void onBeforeGet(CacheKey key) {
        if (this.shouldWatchForChange(key)) {
            LOG.debug("tryAsyncCheck");
            if (this.resourceWatcher.tryAsyncCheck(key)) {
                this.checkedKeys.add(DefaultSynchronizedCacheStrategyDecorator.createIgnoreMinimizeFlagKey(key));
            }
        }
    }

    private boolean shouldWatchForChange(CacheKey key) {
        boolean result = this.getResourceWatcherUpdatePeriod() > 0L && !this.wasCheckedForChange(key);
        LOG.debug("shouldWatchForChange={}", (Object)result);
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            ((MutableResourceAuthorizationManager)this.authorizationManager).clear();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resourceWatcherScheduler.destroy();
    }

    boolean wasCheckedForChange(CacheKey key) {
        return this.checkedKeys.contains(key);
    }
}

