/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertiesAndFilterConfigWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.DefaultRequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.RequestHandlerFactory;
import ro.isdc.wro.http.support.ResponseHeadersConfigurer;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.DefaultWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WroFilter.class);
    private static final String MBEAN_PREFIX = "wro4j-";
    public static final String ATTRIBUTE_PASSED_THROUGH_FILTER = WroFilter.class.getName() + ".passed_through_filter";
    private FilterConfig filterConfig;
    private ObjectFactory<WroConfiguration> wroConfigurationFactory;
    private WroConfiguration wroConfiguration;
    private WroManagerFactory wroManagerFactory;
    private RequestHandlerFactory requestHandlerFactory;
    private ResponseHeadersConfigurer headersConfigurer;
    private boolean enable = true;
    private Injector injector;
    private MBeanServer mbeanServer = null;

    public static boolean isPassedThroughyWroFilter(HttpServletRequest request) {
        Validate.notNull((Object)request);
        return request.getAttribute(ATTRIBUTE_PASSED_THROUGH_FILTER) != null;
    }

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.wroConfiguration = this.createConfiguration();
        this.wroManagerFactory = this.createWroManagerFactory();
        this.injector = InjectorBuilder.create(this.wroManagerFactory).build();
        this.headersConfigurer = this.newResponseHeadersConfigurer();
        this.requestHandlerFactory = DefaultRequestHandlerFactory.decorate(this.newRequestHandlerFactory(), new ObjectFactory<Injector>(){

            @Override
            public Injector create() {
                return WroFilter.this.getInjector();
            }
        });
        this.registerChangeListeners();
        this.registerMBean();
        this.doInit(config);
        LOG.info("wro4j version: {}", (Object)WroUtil.getImplementationVersion());
        LOG.info("wro4j configuration: {}", (Object)this.wroConfiguration);
    }

    private WroConfiguration createConfiguration() {
        WroConfiguration configAttribute = ServletContextAttributeHelper.create(this.filterConfig).getWroConfiguration();
        if (configAttribute != null) {
            this.setConfiguration(configAttribute);
        }
        return this.getWroConfigurationFactory().create();
    }

    private WroManagerFactory createWroManagerFactory() {
        if (this.wroManagerFactory == null) {
            WroManagerFactory managerFactoryAttribute = ServletContextAttributeHelper.create(this.filterConfig).getManagerFactory();
            LOG.debug("managerFactory attribute: {}", (Object)managerFactoryAttribute);
            this.wroManagerFactory = managerFactoryAttribute != null ? managerFactoryAttribute : this.newWroManagerFactory();
        }
        LOG.debug("created managerFactory: {}", (Object)this.wroManagerFactory);
        return this.wroManagerFactory;
    }

    private void registerMBean() {
        if (this.wroConfiguration.isJmxEnabled()) {
            try {
                this.mbeanServer = this.getMBeanServer();
                ObjectName name = this.getMBeanObjectName();
                if (!this.mbeanServer.isRegistered(name)) {
                    this.mbeanServer.registerMBean(this.wroConfiguration, name);
                }
            }
            catch (JMException e) {
                LOG.error("Exception occured while registering MBean", (Throwable)e);
            }
        }
    }

    private void unregisterMBean() {
        try {
            if (this.mbeanServer != null && this.mbeanServer.isRegistered(this.getMBeanObjectName())) {
                this.mbeanServer.unregisterMBean(this.getMBeanObjectName());
            }
        }
        catch (JMException e) {
            LOG.error("Exception occured while registering MBean", (Throwable)e);
        }
    }

    private ObjectName getMBeanObjectName() throws MalformedObjectNameException {
        return new ObjectName(this.newMBeanName(), "type", WroConfiguration.class.getSimpleName());
    }

    protected String newMBeanName() {
        String mbeanName = this.wroConfiguration.getMbeanName();
        if (StringUtils.isEmpty((CharSequence)mbeanName)) {
            String contextPath = this.getContextPath();
            mbeanName = StringUtils.isEmpty((CharSequence)contextPath) ? "ROOT" : contextPath;
            mbeanName = MBEAN_PREFIX + mbeanName;
        }
        return mbeanName;
    }

    private String getContextPath() {
        String contextPath = null;
        try {
            contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)this.filterConfig.getServletContext(), new Object[0]);
        }
        catch (Exception e) {
            contextPath = "DEFAULT";
            LOG.warn("Couldn't identify contextPath because you are using older version of servlet-api (<2.5). Using " + contextPath + " contextPath.");
        }
        return contextPath.replaceFirst("/", "");
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerChangeListeners() {
        this.wroConfiguration.registerCacheUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.headersConfigurer = WroFilter.this.newResponseHeadersConfigurer();
                WroFilter.this.wroManagerFactory.onCachePeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        this.wroConfiguration.registerModelUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.headersConfigurer = WroFilter.this.newResponseHeadersConfigurer();
                WroFilter.this.wroManagerFactory.onModelPeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        LOG.debug("Cache & Model change listeners were registered");
    }

    protected ResponseHeadersConfigurer newResponseHeadersConfigurer() {
        return ResponseHeadersConfigurer.fromConfig(this.wroConfiguration);
    }

    protected RequestHandlerFactory newRequestHandlerFactory() {
        return new DefaultRequestHandlerFactory();
    }

    private long valueAsLong(Object value) {
        Validate.notNull((Object)value);
        return Long.valueOf(String.valueOf(value));
    }

    protected void doInit(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isFilterActive(request)) {
            LOG.debug("processing wro request: {}", (Object)request.getRequestURI());
            try {
                Context.set(Context.webContext(request, response, this.filterConfig), this.wroConfiguration);
                this.addPassThroughFilterAttribute(request);
                if (this.handledWithRequestHandler(request, response)) return;
                this.processRequest(request, response);
                this.onRequestProcessed();
                return;
            }
            catch (Exception e) {
                this.onException(e, response, chain);
                return;
            }
            finally {
                Context.unset();
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void addPassThroughFilterAttribute(HttpServletRequest request) {
        request.setAttribute(ATTRIBUTE_PASSED_THROUGH_FILTER, (Object)Boolean.TRUE);
    }

    private boolean handledWithRequestHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection handlers = (Collection)this.requestHandlerFactory.create();
        Validate.notNull((Object)handlers, (String)"requestHandlers cannot be null!", (Object[])new Object[0]);
        for (RequestHandler requestHandler : handlers) {
            if (!requestHandler.isEnabled() || !requestHandler.accept(request)) continue;
            requestHandler.handle(request, response);
            return true;
        }
        return false;
    }

    Injector getInjector() {
        return this.injector;
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseHeaders(response);
        ((WroManager)this.wroManagerFactory.create()).process();
    }

    private boolean isFilterActive(HttpServletRequest request) {
        return this.enable && !DispatcherStreamLocator.isIncludedRequest(request);
    }

    protected void onException(Exception e, HttpServletResponse response, FilterChain chain) {
        LOG.error("Exception occured", (Throwable)e);
        try {
            LOG.warn("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.debug("Error while chaining the request", (Throwable)ex);
        }
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        this.headersConfigurer.setHeaders(response);
    }

    public void setWroManagerFactory(WroManagerFactory wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    public final WroManagerFactory getWroManagerFactory() {
        return this.wroManagerFactory;
    }

    public void setRequestHandlerFactory(RequestHandlerFactory requestHandlerFactory) {
        Validate.notNull((Object)requestHandlerFactory);
        this.requestHandlerFactory = requestHandlerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() {
        return DefaultWroManagerFactory.create(this.wroConfigurationFactory);
    }

    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory(FilterConfig filterConfig) {
        return new PropertiesAndFilterConfigWroConfigurationFactory(filterConfig);
    }

    private ObjectFactory<WroConfiguration> getWroConfigurationFactory() {
        if (this.wroConfigurationFactory == null) {
            this.wroConfigurationFactory = this.newWroConfigurationFactory(this.filterConfig);
        }
        return this.wroConfigurationFactory;
    }

    public void setWroConfigurationFactory(ObjectFactory<WroConfiguration> wroConfigurationFactory) {
        this.wroConfigurationFactory = wroConfigurationFactory;
    }

    public final WroConfiguration getConfiguration() {
        return this.wroConfiguration;
    }

    public final void setConfiguration(final WroConfiguration config) {
        Validate.notNull((Object)config);
        this.wroConfigurationFactory = new ObjectFactory<WroConfiguration>(){

            @Override
            public WroConfiguration create() {
                return config;
            }
        };
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    protected void onRequestProcessed() {
    }

    public void destroy() {
        this.unregisterMBean();
        if (this.wroManagerFactory != null) {
            this.wroManagerFactory.destroy();
        }
        if (this.wroConfiguration != null) {
            this.wroConfiguration.destroy();
        }
        Context.destroy();
    }
}

