/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.FallbackAwareWroModelFactory;
import ro.isdc.wro.model.factory.ModelTransformerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.util.AbstractDecorator;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultWroModelFactoryDecorator
extends AbstractDecorator<WroModelFactory>
implements WroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWroModelFactoryDecorator.class);
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private ResourceAuthorizationManager authorizationManager;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private Injector injector;
    private final DestroyableLazyInitializer<WroModel> modelInitializer = new DestroyableLazyInitializer<WroModel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected WroModel initialize() {
            WroModel wroModel;
            DefaultWroModelFactoryDecorator.this.callbackRegistry.onBeforeModelCreated();
            StopWatch watch = new StopWatch("Create Model");
            watch.start("createModel");
            WroModel model = null;
            try {
                WroModelFactory modelFactory = this.decorate((WroModelFactory)DefaultWroModelFactoryDecorator.this.getDecoratedObject());
                DefaultWroModelFactoryDecorator.this.injector.inject(modelFactory);
                wroModel = model = (WroModel)modelFactory.create();
                this.authorizeModelResources(model);
                DefaultWroModelFactoryDecorator.this.callbackRegistry.onAfterModelCreated();
            }
            catch (Throwable throwable) {
                this.authorizeModelResources(model);
                DefaultWroModelFactoryDecorator.this.callbackRegistry.onAfterModelCreated();
                watch.stop();
                LOG.debug(watch.prettyPrint());
                throw throwable;
            }
            watch.stop();
            LOG.debug(watch.prettyPrint());
            return wroModel;
        }

        private WroModelFactory decorate(WroModelFactory decorated) {
            return new ModelTransformerFactory(new FallbackAwareWroModelFactory(decorated)).setTransformers(DefaultWroModelFactoryDecorator.this.modelTransformers);
        }

        private void authorizeModelResources(WroModel model) {
            if (model != null && DefaultWroModelFactoryDecorator.this.context.getConfig().isDebug() && DefaultWroModelFactoryDecorator.this.authorizationManager instanceof MutableResourceAuthorizationManager) {
                for (Resource resource : new WroModelInspector(model).getAllUniqueResources()) {
                    ((MutableResourceAuthorizationManager)DefaultWroModelFactoryDecorator.this.authorizationManager).add(resource.getUri());
                }
            }
        }
    };
    private final List<Transformer<WroModel>> modelTransformers;

    public static WroModelFactory decorate(WroModelFactory decorated, List<Transformer<WroModel>> modelTransformers) {
        return decorated instanceof DefaultWroModelFactoryDecorator ? decorated : new DefaultWroModelFactoryDecorator(decorated, modelTransformers);
    }

    private DefaultWroModelFactoryDecorator(WroModelFactory decorated, List<Transformer<WroModel>> modelTransformers) {
        super(decorated);
        Validate.notNull(modelTransformers);
        this.modelTransformers = modelTransformers;
    }

    @Override
    public WroModel create() {
        return (WroModel)this.modelInitializer.get();
    }

    @Override
    public void destroy() {
        LOG.debug("Destroy model");
        this.modelInitializer.destroy();
        ((WroModelFactory)this.getDecoratedObject()).destroy();
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            ((MutableResourceAuthorizationManager)this.authorizationManager).clear();
        }
    }
}

