/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroModelInspector {
    private Map<String, Group> map = new HashMap<String, Group>();

    public WroModelInspector(WroModel model) {
        Validate.notNull((Object)model);
        for (Group group : model.getGroups()) {
            this.map.put(group.getName(), group);
        }
    }

    public Group getGroupByName(String name) {
        return this.map.get(name);
    }

    public Collection<String> getGroupNamesContainingResource(String resourceUri) {
        Validate.notNull((Object)resourceUri);
        HashSet<String> groupNames = new HashSet<String>();
        for (Group group : this.map.values()) {
            if (!group.hasResource(resourceUri)) continue;
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public final List<String> getGroupNames() {
        return new ArrayList<String>(this.map.keySet());
    }

    public boolean hasGroup(String groupName) {
        return this.map.containsKey(groupName);
    }

    public String getGroupNamesAsString() {
        return String.format("%s", StringUtils.join(this.getGroupNames(), (String)", "));
    }

    public Collection<Resource> getAllUniqueResources() {
        return this.collectResources(new HashSet<Resource>());
    }

    public Collection<Resource> getAllResources() {
        return this.collectResources(new ArrayList<Resource>());
    }

    private Collection<Resource> collectResources(Collection<Resource> resources) {
        for (Group group : this.map.values()) {
            resources.addAll(group.getResources());
        }
        return resources;
    }
}

