/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ConfigurableCacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.ServletContextPropertyWroConfigurationFactory;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.ConfigurableLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.support.LocatorProvider;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;
import ro.isdc.wro.model.resource.support.hash.ConfigurableHashStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.ConfigurableNamingStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableWroManagerFactory
extends BaseWroManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWroManagerFactory.class);
    private Properties configProperties;

    protected void contributeLocators(Map<String, UriLocator> map) {
    }

    protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
    }

    protected void contributePostProcessors(Map<String, ResourcePostProcessor> map) {
    }

    @Override
    protected UriLocatorFactory newUriLocatorFactory() {
        ConfigurableLocatorFactory factory = new ConfigurableLocatorFactory(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "uriLocators");
                return props;
            }

            @Override
            protected Map<String, UriLocator> getStrategies(LocatorProvider provider) {
                Map<String, UriLocator> map = super.getStrategies(provider);
                ConfigurableWroManagerFactory.this.contributeLocators(map);
                return map;
            }
        };
        return factory;
    }

    @Override
    protected ProcessorsFactory newProcessorsFactory() {
        ConfigurableProcessorsFactory factory = new ConfigurableProcessorsFactory(){

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "preProcessors");
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "postProcessors");
                return props;
            }

            @Override
            protected Map<String, ResourcePostProcessor> getPostProcessorStrategies(ProcessorProvider provider) {
                Map<String, ResourcePostProcessor> map = super.getPostProcessorStrategies(provider);
                ConfigurableWroManagerFactory.this.contributePostProcessors(map);
                return map;
            }

            @Override
            protected Map<String, ResourcePreProcessor> getPreProcessorStrategies(ProcessorProvider provider) {
                Map<String, ResourcePreProcessor> map = super.getPreProcessorStrategies(provider);
                ConfigurableWroManagerFactory.this.contributePreProcessors(map);
                return map;
            }
        };
        return factory;
    }

    @Override
    protected NamingStrategy newNamingStrategy() {
        return new ConfigurableNamingStrategy(){

            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "namingStrategy");
                return props;
            }
        };
    }

    @Override
    protected HashStrategy newHashStrategy() {
        return new ConfigurableHashStrategy(){

            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "hashStrategy");
                return props;
            }
        };
    }

    @Override
    protected CacheStrategy<CacheEntry, ContentHashEntry> newCacheStrategy() {
        return new ConfigurableCacheStrategy(){

            protected Properties newProperties() {
                Properties props = new Properties();
                ConfigurableWroManagerFactory.this.updatePropertiesWithConfiguration(props, "cacheStrategy");
                return props;
            }
        };
    }

    private void updatePropertiesWithConfiguration(Properties props, String key) {
        FilterConfig filterConfig = Context.get().getFilterConfig();
        String valuesAsString = filterConfig.getInitParameter(key);
        if (valuesAsString != null) {
            props.setProperty(key, valuesAsString);
        } else {
            String value = this.getConfigProperties().getProperty(key);
            if (value != null) {
                props.setProperty(key, value);
            }
        }
    }

    private Properties getConfigProperties() {
        if (this.configProperties == null) {
            this.configProperties = this.newConfigProperties();
        }
        return this.configProperties;
    }

    protected Properties newConfigProperties() {
        Properties props = new Properties();
        try {
            return new ServletContextPropertyWroConfigurationFactory(Context.get().getServletContext()).createProperties();
        }
        catch (Exception e) {
            LOG.debug("No configuration property file found.");
            return props;
        }
    }

    public ConfigurableWroManagerFactory setConfigProperties(Properties configProperties) {
        Validate.notNull((Object)configProperties);
        this.configProperties = configProperties;
        return this;
    }
}

