/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.encoding.CharsetToolkit;

public class SmartEncodingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SmartEncodingInputStream.class);
    private final InputStream is;
    private int bufferLength;
    private final byte[] buffer;
    private int counter;
    private final Charset charset;
    public static final int BUFFER_LENGTH_2KB = 2048;
    public static final int BUFFER_LENGTH_4KB = 4096;
    public static final int BUFFER_LENGTH_8KB = 8192;

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset, boolean enforce8Bit) throws IOException {
        this.is = is;
        this.bufferLength = bufferLength;
        this.buffer = new byte[bufferLength];
        this.counter = 0;
        this.bufferLength = is.read(this.buffer);
        CharsetToolkit charsetToolkit = new CharsetToolkit(this.buffer, defaultCharset);
        charsetToolkit.setEnforce8Bit(enforce8Bit);
        this.charset = charsetToolkit.guessEncoding();
        LOG.debug("detected charset: " + this.charset);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset) throws IOException {
        this(is, bufferLength, defaultCharset, true);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength) throws IOException {
        this(is, bufferLength, null, true);
    }

    public SmartEncodingInputStream(InputStream is) throws IOException {
        this(is, 8192, null, true);
    }

    public int read() throws IOException {
        if (this.counter < this.bufferLength) {
            return this.buffer[this.counter++];
        }
        return this.is.read();
    }

    public Reader getReader() {
        return new InputStreamReader((InputStream)this, this.charset);
    }

    public Charset getEncoding() {
        return this.charset;
    }
}

