/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.util.HashBuilder;

public abstract class AbstractDigesterHashBuilder
implements HashBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDigesterHashBuilder.class);

    public String getHash(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Content cannot be null!");
        }
        try {
            LOG.debug("creating hash using SHA1 algorithm");
            MessageDigest messageDigest = this.newMessageDigest();
            DigestInputStream digestIs = new DigestInputStream(input, messageDigest);
            while (((InputStream)digestIs).read() != -1) {
            }
            byte[] digest = messageDigest.digest();
            String hash = new BigInteger(1, digest).toString(16);
            LOG.debug(this.getClass().getSimpleName() + " hash: " + hash);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WroRuntimeException("Exception occured while computing SHA1 hash", e);
        }
    }

    protected abstract MessageDigest newMessageDigest() throws NoSuchAlgorithmException;
}

