/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.js;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.algorithm.JSMin;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class JSMinProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSMinProcessor.class);

    public void process(Reader reader, Writer writer) throws IOException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(IOUtils.toByteArray((Reader)reader));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JSMin jsmin = new JSMin(is, os);
            jsmin.jsmin();
            IOUtils.write((byte[])os.toByteArray(), (Writer)writer);
            ((InputStream)is).close();
            os.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception wile processing js using JSMin", (Throwable)e);
            throw new WroRuntimeException("Exception wile processing js using JSMin", e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.process(reader, writer);
    }
}

