/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public class CssImportPreProcessor
implements ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssImportPreProcessor.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private PreProcessorExecutor preProcessorExecutor;
    private final List<Resource> processed = new ArrayList<Resource>();
    private static final Pattern PATTERN = Pattern.compile("@import\\s*(?:url\\()?[\"']?([^\"')]+)[\"')]?\\)?;?", 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.validate();
        try {
            String result = this.parseCss(resource, reader);
            writer.write(result);
            this.processed.clear();
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private void validate() {
        if (this.uriLocatorFactory == null) {
            throw new IllegalStateException("No UriLocator was injected");
        }
        if (this.preProcessorExecutor == null) {
            throw new IllegalStateException("No preProcessorExecutor was injected");
        }
    }

    private String parseCss(Resource resource, Reader reader) throws IOException {
        if (this.processed.contains(resource)) {
            LOG.warn("Recursive import detected: " + resource);
            return "";
        }
        this.processed.add(resource);
        StringBuffer sb = new StringBuffer();
        List<Resource> importsCollector = this.getImportedResources(resource);
        sb.append(this.preProcessorExecutor.processAndMerge(importsCollector, true));
        if (!importsCollector.isEmpty()) {
            LOG.debug("Imported resources found : " + importsCollector.size());
        }
        sb.append(IOUtils.toString((Reader)reader));
        LOG.debug("importsCollector: " + importsCollector);
        return this.removeImportStatements(sb.toString());
    }

    private String removeImportStatements(String content) {
        Matcher m = PATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List<Resource> getImportedResources(Resource resource) throws IOException {
        ArrayList<Resource> imports = new ArrayList<Resource>();
        String css = IOUtils.toString((InputStream)this.uriLocatorFactory.locate(resource.getUri()));
        Matcher m = PATTERN.matcher(css);
        while (m.find()) {
            Resource importedResource = this.buildImportedResource(resource, m.group(1));
            if (imports.contains(importedResource)) {
                LOG.warn("Duplicate imported resource: " + importedResource);
                continue;
            }
            imports.add(importedResource);
        }
        return imports;
    }

    private Resource buildImportedResource(Resource resource, String importUrl) {
        String absoluteUrl = this.computeAbsoluteUrl(resource, importUrl);
        Resource importResource = Resource.create(absoluteUrl, ResourceType.CSS);
        return importResource;
    }

    private String computeAbsoluteUrl(Resource relativeResource, String importUrl) {
        String folder = FilenameUtils.getFullPath((String)relativeResource.getUri());
        String absoluteImportUrl = StringUtils.normalizePath(folder + importUrl);
        return absoluteImportUrl;
    }
}

