/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.algorithm.DataUriGenerator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;

public class CssDataUriPreProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssDataUriPreProcessor.class);
    private DataUriGenerator dataUriGenerator;
    @Inject
    private UriLocatorFactory uriLocatorFactory;

    protected final String replaceImageUrl(String cssUri, String imageUrl) {
        if (this.uriLocatorFactory == null) {
            throw new IllegalStateException("No UriLocatorFactory was injected!");
        }
        LOG.debug("replace url for image: " + imageUrl + ", from css: " + cssUri);
        String cleanImageUrl = this.cleanImageUrl(imageUrl);
        String fileName = FilenameUtils.getName((String)imageUrl);
        String fullPath = FilenameUtils.getFullPath((String)cssUri) + cleanImageUrl;
        String result = imageUrl;
        try {
            String dataUri = this.getDataUriGenerator().generateDataURI(this.uriLocatorFactory.locate(fullPath), fileName);
            if (this.replaceWithDataUri(dataUri)) {
                result = dataUri;
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't extract dataUri from:" + fullPath + ", because: " + e.getMessage());
        }
        return result;
    }

    private DataUriGenerator getDataUriGenerator() {
        if (this.dataUriGenerator == null) {
            this.dataUriGenerator = new DataUriGenerator();
        }
        return this.dataUriGenerator;
    }

    protected boolean replaceWithDataUri(String dataUri) throws UnsupportedEncodingException {
        byte[] bytes = dataUri.getBytes("UTF8");
        int limit = 32768;
        boolean exceedLimit = bytes.length >= 32768;
        LOG.debug("dataUri size: " + bytes.length / 1024 + "KB, limit exceeded: " + exceedLimit);
        return !exceedLimit;
    }
}

