/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.InvalidGroupNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WroModel {
    private Set<Group> groups = new HashSet<Group>();

    public final Set<Group> getGroups() {
        return this.groups;
    }

    public final List<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : this.getGroups()) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public final void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public Group getGroupByName(String name) {
        for (Group group : this.groups) {
            if (!name.equals(group.getName())) continue;
            return group;
        }
        throw new InvalidGroupNameException("There is no such group: '" + name + "'. Available groups are: " + this.groups);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("groups", this.groups).toString();
    }
}

