/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.HttpHeader;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.manager.WroManagerFactory;
import ro.isdc.wro.manager.factory.ServletContextAwareWroManagerFactory;
import ro.isdc.wro.util.WroUtil;

public class WroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WroFilter.class);
    private static final String MBEAN_PREFIX = "wro4j-";
    static final String PARAM_HEADER = "header";
    static final String PARAM_MANAGER_FACTORY = "managerFactoryClassName";
    static final String PARAM_CONFIGURATION = "configuration";
    static final String PARAM_VALUE_DEPLOYMENT = "DEPLOYMENT";
    static final String PARAM_GZIP_RESOURCES = "gzipResources";
    static final String PARAM_CACHE_UPDATE_PERIOD = "cacheUpdatePeriod";
    static final String PARAM_MODEL_UPDATE_PERIOD = "modelUpdatePeriod";
    static final String PARAM_JMX_ENABLED = "jmxEnabled";
    static final String PARAM_MBEAN_NAME = "mbeanName";
    private static final String DEFAULT_CACHE_CONTROL_VALUE = "public, max-age=315360000, post-check=315360000, pre-check=315360000";
    private FilterConfig filterConfig;
    private WroConfiguration wroConfiguration;
    private WroManagerFactory wroManagerFactory;
    private final Map<String, String> headersMap = new LinkedHashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            return super.put(key.trim().toLowerCase(), value);
        }

        @Override
        public String get(Object key) {
            return (String)super.get(((String)key).toLowerCase());
        }
    };

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.wroConfiguration = new WroConfiguration();
        this.initConfiguration(this.wroConfiguration);
        this.initWroManagerFactory();
        this.initHeaderValues();
        this.initJMX();
        this.doInit(config);
    }

    private void initWroManagerFactory() {
        this.wroManagerFactory = this.getWroManagerFactory();
        if (this.wroManagerFactory instanceof CacheChangeCallbackAware) {
            ((CacheChangeCallbackAware)((Object)this.wroManagerFactory)).registerCallback(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    WroFilter.this.initHeaderValues();
                }
            });
        }
    }

    private void initJMX() {
        try {
            ObjectName name;
            MBeanServer mbeanServer;
            boolean jmxEnabled = this.getJmxEnabled();
            LOG.info("jmxEnabled: " + jmxEnabled);
            this.registerChangeListeners();
            if (jmxEnabled && !(mbeanServer = this.getMBeanServer()).isRegistered(name = new ObjectName(this.newMBeanName(), "type", WroConfiguration.class.getSimpleName()))) {
                mbeanServer.registerMBean(this.wroConfiguration, name);
            }
            LOG.info("wro4j configuration: " + this.wroConfiguration);
        }
        catch (JMException e) {
            LOG.error("Exception occured while registering MBean", (Throwable)e);
        }
    }

    protected boolean getJmxEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)this.filterConfig.getInitParameter(PARAM_JMX_ENABLED)), (boolean)true);
    }

    protected String newMBeanName() {
        String mbeanName = this.filterConfig.getInitParameter(PARAM_MBEAN_NAME);
        if (StringUtils.isEmpty((String)mbeanName)) {
            String contextPath = this.getContextPath();
            mbeanName = StringUtils.isEmpty((String)contextPath) ? "ROOT" : contextPath;
            mbeanName = MBEAN_PREFIX + contextPath;
        }
        return mbeanName;
    }

    private String getContextPath() {
        String contextPath = null;
        try {
            contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)this.filterConfig.getServletContext(), new Object[0]);
        }
        catch (Exception e) {
            contextPath = "DEFAULT";
            LOG.warn("Couldn't identify contextPath because you are using older version of servlet-api (<2.5). Using " + contextPath + " contextPath.");
        }
        return contextPath.replaceFirst("/", "");
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerChangeListeners() {
        this.wroConfiguration.registerCacheUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                if (WroFilter.this.wroManagerFactory instanceof WroConfigurationChangeListener) {
                    ((WroConfigurationChangeListener)((Object)WroFilter.this.wroManagerFactory)).onCachePeriodChanged();
                }
            }
        });
        this.wroConfiguration.registerModelUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                if (WroFilter.this.wroManagerFactory instanceof WroConfigurationChangeListener) {
                    ((WroConfigurationChangeListener)((Object)WroFilter.this.wroManagerFactory)).onModelPeriodChanged();
                }
            }
        });
        LOG.debug("Cache & Model change listeners were registered");
    }

    private long getUpdatePeriodByName(String paramName) {
        String valueAsString = this.filterConfig.getInitParameter(paramName);
        if (valueAsString == null) {
            return 0L;
        }
        try {
            return Long.valueOf(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new WroRuntimeException(paramName + " init-param must be a number, but was: " + valueAsString);
        }
    }

    private void initConfiguration(WroConfiguration config) {
        config.setGzipEnabled(this.isGzipResources());
        config.setDebug(this.isDebug());
        config.setCacheUpdatePeriod(this.getCacheUpdatePeriod());
        config.setModelUpdatePeriod(this.getModelUpdatePeriod());
    }

    protected boolean isGzipResources() {
        String gzipParam = this.filterConfig.getInitParameter(PARAM_GZIP_RESOURCES);
        boolean gzipResources = gzipParam == null ? true : Boolean.valueOf(gzipParam);
        return gzipResources;
    }

    protected boolean isDebug() {
        boolean debug = true;
        String configParam = this.filterConfig.getInitParameter(PARAM_CONFIGURATION);
        if (configParam != null && PARAM_VALUE_DEPLOYMENT.equalsIgnoreCase(configParam)) {
            debug = false;
        }
        return debug;
    }

    protected long getModelUpdatePeriod() {
        return this.getUpdatePeriodByName(PARAM_MODEL_UPDATE_PERIOD);
    }

    protected long getCacheUpdatePeriod() {
        return this.getUpdatePeriodByName(PARAM_CACHE_UPDATE_PERIOD);
    }

    private void initHeaderValues() {
        Long timestamp = new Date().getTime();
        Calendar cal = Calendar.getInstance();
        cal.roll(1, 10);
        this.headersMap.put(HttpHeader.CACHE_CONTROL.toString(), DEFAULT_CACHE_CONTROL_VALUE);
        this.headersMap.put(HttpHeader.LAST_MODIFIED.toString(), WroUtil.toDateAsString(timestamp));
        this.headersMap.put(HttpHeader.EXPIRES.toString(), WroUtil.toDateAsString(cal.getTimeInMillis()));
        String headerParam = this.filterConfig.getInitParameter(PARAM_HEADER);
        if (headerParam != null) {
            try {
                if (headerParam.contains("|")) {
                    String[] headers;
                    for (String header : headers = headerParam.split("[|]")) {
                        this.parseHeader(header);
                    }
                } else {
                    this.parseHeader(headerParam);
                }
            }
            catch (Exception e) {
                throw new WroRuntimeException("Invalid header init-param value: " + headerParam + ". A correct value should have the following format: " + "<HEADER_NAME1>: <VALUE1> | <HEADER_NAME2>: <VALUE2>. " + "Ex: <look like this: " + "Expires: Thu, 15 Apr 2010 20:00:00 GMT | cache-control: public", e);
            }
        }
        LOG.debug("Header Values: " + this.headersMap);
    }

    private void parseHeader(String header) {
        LOG.debug("parseHeader: " + header);
        String headerName = header.substring(0, header.indexOf(":"));
        if (!this.headersMap.containsKey(headerName)) {
            this.headersMap.put(headerName, header.substring(header.indexOf(":") + 1));
        }
    }

    protected void doInit(FilterConfig config) throws ServletException {
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Context.set(Context.webContext(request, response, this.filterConfig), this.wroConfiguration);
            this.processRequest(request, response);
            Context.unset();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e, response, chain);
        }
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseHeaders(response);
        this.wroManagerFactory.getInstance().process();
    }

    protected void onRuntimeException(RuntimeException e, HttpServletResponse response, FilterChain chain) {
        LOG.debug("runtime exception occured", (Throwable)e);
        try {
            LOG.debug("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.error("Error while chaining the request: 404");
        }
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    protected WroManagerFactory getWroManagerFactory() {
        String appFactoryClassName = this.filterConfig.getInitParameter(PARAM_MANAGER_FACTORY);
        if (appFactoryClassName == null) {
            return new ServletContextAwareWroManagerFactory();
        }
        Class<?> factoryClass = null;
        try {
            factoryClass = Thread.currentThread().getContextClassLoader().loadClass(appFactoryClassName);
            return (WroManagerFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new WroRuntimeException("Exception while loading WroManagerFactory class", e);
        }
    }

    public final WroConfiguration getWroConfiguration() {
        return this.wroConfiguration;
    }

    public void destroy() {
        this.wroConfiguration.destroy();
        Context.destroy();
        this.wroManagerFactory.destroy();
    }
}

