/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class AzureDevOpsBuildServerData
extends BuildServerDataProvider {
    AzureDevOpsBuildServerData(@Nonnull LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("AZURE_HTTP_USER_AGENT");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = (String)this.env.get("BUILD_BUILDNUMBER");
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBuildSourceBranchName = (String)this.env.get("BUILD_SOURCEBRANCHNAME");
        this.log.info("Using environment variable based branch name. BUILD_SOURCEBRANCHNAME = {}", (Object)environmentBasedBuildSourceBranchName);
        return environmentBasedBuildSourceBranchName;
    }
}

