/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xmlunit.util.IterableNodeList;
import org.xmlunit.util.Predicate;

public final class Nodes {
    private static final char SPACE = ' ';

    private Nodes() {
    }

    public static QName getQName(Node n) {
        String s = n.getLocalName();
        String p = n.getPrefix();
        return s != null ? new QName(n.getNamespaceURI(), s, p != null ? p : "") : new QName(n.getNodeName());
    }

    public static String getMergedNestedText(Node n) {
        StringBuilder sb = new StringBuilder();
        for (Node child : new IterableNodeList(Nodes.getChildNodes(n))) {
            String s;
            if (!(child instanceof Text) || (s = child.getNodeValue()) == null) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public static Map<QName, String> getAttributes(Node n) {
        return Nodes.getAttributes(n, new Predicate<Attr>(){

            @Override
            public boolean test(Attr a) {
                return true;
            }
        });
    }

    public static Map<QName, String> getAttributes(Node n, Predicate<Attr> attributeFilter) {
        LinkedHashMap<QName, String> map = new LinkedHashMap<QName, String>();
        NamedNodeMap m = n.getAttributes();
        if (m != null) {
            int len = m.getLength();
            for (int i = 0; i < len; ++i) {
                Attr a = (Attr)m.item(i);
                if (!attributeFilter.test(a)) continue;
                map.put(Nodes.getQName(a), a.getValue());
            }
        }
        return map;
    }

    public static Node stripWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.handleWsRec(cloned, false);
        return cloned;
    }

    public static Node normalizeWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.handleWsRec(cloned, true);
        return cloned;
    }

    public static Node stripElementContentWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.stripECW(cloned);
        return cloned;
    }

    public static NodeList getChildNodes(Node n) {
        NodeList nl = n.getChildNodes();
        if (!(n instanceof Attr) || nl.getLength() != 1 || nl.item(0) != null) {
            return nl;
        }
        return new EmptyTextNodeNodeList(n.getOwnerDocument());
    }

    private static void handleWsRec(Node n, boolean normalize) {
        if (n instanceof CharacterData || n instanceof ProcessingInstruction) {
            String s = n.getNodeValue().trim();
            if (normalize) {
                s = Nodes.normalize(s);
            }
            n.setNodeValue(s);
        }
        LinkedList<Node> toRemove = new LinkedList<Node>();
        for (Node child : new IterableNodeList(Nodes.getChildNodes(n))) {
            Nodes.handleWsRec(child, normalize);
            if (n instanceof Attr || !(child instanceof Text) || child.getNodeValue().length() != 0) continue;
            toRemove.add(child);
        }
        for (Node child : toRemove) {
            n.removeChild(child);
        }
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                Nodes.handleWsRec(attrs.item(i), normalize);
            }
        }
    }

    static String normalize(String s) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        boolean lastCharWasWS = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!lastCharWasWS) {
                    sb.append(' ');
                    changed |= c != ' ';
                } else {
                    changed = true;
                }
                lastCharWasWS = true;
                continue;
            }
            sb.append(c);
            lastCharWasWS = false;
        }
        return changed ? sb.toString() : s;
    }

    private static void stripECW(Node n) {
        LinkedList<Node> toRemove = new LinkedList<Node>();
        for (Node child : new IterableNodeList(Nodes.getChildNodes(n))) {
            Nodes.stripECW(child);
            if (n instanceof Attr || !(child instanceof Text) || child.getNodeValue().trim().length() != 0) continue;
            toRemove.add(child);
        }
        for (Node child : toRemove) {
            n.removeChild(child);
        }
    }

    private static class EmptyTextNodeNodeList
    implements NodeList {
        private final Text emptyStringNode;

        private EmptyTextNodeNodeList(Document d) {
            this.emptyStringNode = d.createTextNode("");
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public Node item(int index) {
            return index == 0 ? this.emptyStringNode : null;
        }
    }
}

