/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import org.jboss.as.ee.concurrent.resource.definition.ManagedThreadFactoryDefinitionInjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionAnnotationProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public class ManagedThreadFactoryDefinitionAnnotationProcessor
extends ResourceDefinitionAnnotationProcessor {
    private static final DotName MANAGED_THREAD_FACTORY_DEFINITION = DotName.createSimple((String)ManagedThreadFactoryDefinition.class.getName());
    private static final DotName MANAGED_THREAD_FACTORY_DEFINITION_LIST = DotName.createSimple((String)ManagedThreadFactoryDefinition.List.class.getName());

    @Override
    protected DotName getAnnotationDotName() {
        return MANAGED_THREAD_FACTORY_DEFINITION;
    }

    @Override
    protected DotName getAnnotationCollectionDotName() {
        return MANAGED_THREAD_FACTORY_DEFINITION_LIST;
    }

    @Override
    protected ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        String jndiName = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString(annotationInstance, "name");
        String context = ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString(annotationInstance, "context");
        int priority = ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalInt(annotationInstance, "priority");
        ManagedThreadFactoryDefinitionInjectionSource injectionSource = new ManagedThreadFactoryDefinitionInjectionSource(jndiName);
        injectionSource.setContextServiceRef(context);
        injectionSource.setPriority(priority > 0 ? priority : 5);
        return injectionSource;
    }
}

