/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.realm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddLdapRealm
implements OnlineCommand {
    private final String name;
    private final String dirContext;
    private final Boolean directVerification;
    private final Boolean allowBlankPassword;
    private final IdentityMapping identityMapping;
    private final boolean replaceExisting;

    private AddLdapRealm(Builder builder) {
        this.name = builder.name;
        this.dirContext = builder.dirContext;
        this.directVerification = builder.directVerification;
        this.allowBlankPassword = builder.allowBlankPassword;
        this.identityMapping = builder.identityMapping;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        ModelNode node;
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        Operations ops = new Operations(ctx.client);
        Address realmAddress = Address.subsystem((String)"elytron").and("ldap-realm", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(realmAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ModelNode identityMappingModelNode = new ModelNode();
        identityMappingModelNode.add("rdn-identifier", this.identityMapping.getRdnIdentifier());
        this.addOptionalToModelNode(identityMappingModelNode, "search-base-dn", this.identityMapping.getSearchBaseDn());
        this.addOptionalToModelNode(identityMappingModelNode, "use-recursive-search", this.identityMapping.getUseRecursiveSearch());
        this.addOptionalToModelNode(identityMappingModelNode, "filter-name", this.identityMapping.getFilterName());
        this.addOptionalToModelNode(identityMappingModelNode, "iterator-filter", this.identityMapping.getIteratorFilter());
        this.addOptionalToModelNode(identityMappingModelNode, "new-identity-parent-dn", this.identityMapping.getNewIdentityParentDn());
        if (this.identityMapping.getAttributeMappings() != null && !this.identityMapping.getAttributeMappings().isEmpty()) {
            ArrayList<ModelNode> newAttributeMappingNodeList = new ArrayList<ModelNode>();
            for (AttributeMapping attributeMapping : this.identityMapping.getAttributeMappings()) {
                ModelNode node2 = new ModelNode();
                this.addOptionalToModelNode(node2, "from", attributeMapping.getFrom());
                this.addOptionalToModelNode(node2, "to", attributeMapping.getTo());
                this.addOptionalToModelNode(node2, "filter", attributeMapping.getFilter());
                this.addOptionalToModelNode(node2, "filter-base-dn", attributeMapping.getFilterBaseDn());
                this.addOptionalToModelNode(node2, "extract-rdn", attributeMapping.getExtractRdn());
                this.addOptionalToModelNode(node2, "search-recursive", attributeMapping.getSearchRecursive());
                this.addOptionalToModelNode(node2, "role-recursion", attributeMapping.getRoleRecursion());
                this.addOptionalToModelNode(node2, "role-recursion-name", attributeMapping.getRoleRecursionName());
                this.addOptionalToModelNode(node2, "reference", attributeMapping.getReference());
                node2 = node2.asObject();
                newAttributeMappingNodeList.add(node2);
            }
            ModelNode attributeMappingNode = new ModelNode();
            attributeMappingNode.set(newAttributeMappingNodeList);
            identityMappingModelNode.add("attribute-mapping", attributeMappingNode);
        }
        if (this.identityMapping.getUserPasswordMapper() != null) {
            node = new ModelNode();
            node.add("from", this.identityMapping.getUserPasswordMapper().getFrom());
            this.addOptionalToModelNode(node, "writable", this.identityMapping.getUserPasswordMapper().getWritable());
            this.addOptionalToModelNode(node, "verifiable", this.identityMapping.getUserPasswordMapper().getVerifiable());
            identityMappingModelNode.add("user-password-mapper", node.asObject());
        }
        if (this.identityMapping.getOtpCredentialMapper() != null) {
            node = new ModelNode();
            node.add("algorithm-from", this.identityMapping.getOtpCredentialMapper().getAlgorithmFrom());
            node.add("hash-from", this.identityMapping.getOtpCredentialMapper().getHashFrom());
            node.add("seed-from", this.identityMapping.getOtpCredentialMapper().getSeedFrom());
            node.add("sequence-from", this.identityMapping.getOtpCredentialMapper().getSequenceFrom());
            identityMappingModelNode.add("otp-credential-mapper", node.asObject());
        }
        if (this.identityMapping.getX509CredentialMapper() != null) {
            node = new ModelNode();
            this.addOptionalToModelNode(node, "digest-from", this.identityMapping.getX509CredentialMapper().getDigestFrom());
            this.addOptionalToModelNode(node, "digest-algorithm", this.identityMapping.getX509CredentialMapper().getDigestAlgorithm());
            this.addOptionalToModelNode(node, "certificate-from", this.identityMapping.getX509CredentialMapper().getCertificateFrom());
            this.addOptionalToModelNode(node, "serial-number-from", this.identityMapping.getX509CredentialMapper().getSerialNumberFrom());
            this.addOptionalToModelNode(node, "subject-dn-from", this.identityMapping.getX509CredentialMapper().getSubjectDnFrom());
            identityMappingModelNode.add("x509-credential-mapper", node.asObject());
        }
        if (this.identityMapping.getNewIdentityAttributes() != null && !this.identityMapping.getNewIdentityAttributes().isEmpty()) {
            ArrayList<ModelNode> newIdentityAttributesNodeList = new ArrayList<ModelNode>();
            for (NewIdentityAttributes newIdentityAttribute : this.identityMapping.getNewIdentityAttributes()) {
                ModelNode attributeNode = new ModelNode();
                this.addOptionalToModelNode(attributeNode, "name", newIdentityAttribute.getName());
                ModelNode valuesList = new ModelNode().setEmptyList();
                for (String value : newIdentityAttribute.getValues()) {
                    valuesList.add(value);
                }
                attributeNode.add("value", valuesList);
                attributeNode = attributeNode.asObject();
                newIdentityAttributesNodeList.add(attributeNode);
            }
            ModelNode newIdentityAttributesNode = new ModelNode();
            newIdentityAttributesNode.set(newIdentityAttributesNodeList);
            identityMappingModelNode.add("new-identity-attributes", newIdentityAttributesNode);
        }
        ops.add(realmAddress, Values.empty().and("dir-context", this.dirContext).andOptional("direct-verification", this.directVerification).andOptional("allow-blank-password", this.allowBlankPassword).and("identity-mapping", identityMappingModelNode.asObject()));
    }

    private void addOptionalToModelNode(ModelNode node, String name, String value) {
        if (value != null && !value.isEmpty()) {
            node.add(name, value);
        }
    }

    private void addOptionalToModelNode(ModelNode node, String name, Boolean value) {
        if (value != null) {
            node.add(name, value.booleanValue());
        }
    }

    private void addOptionalToModelNode(ModelNode node, String name, Integer value) {
        if (value != null) {
            node.add(name, value.intValue());
        }
    }

    public static final class NewIdentityAttributesBuilder {
        private String name;
        private List<String> values = new ArrayList<String>();

        public NewIdentityAttributesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NewIdentityAttributesBuilder addValues(String ... values) {
            if (values == null) {
                throw new IllegalArgumentException("Values added to NewIdentityAttributesBuilder for ldap-realm must not be null");
            }
            Collections.addAll(this.values, values);
            return this;
        }

        public NewIdentityAttributes build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("name must not be null and must have a minimum length of 1 characters");
            }
            if (this.values == null || this.values.isEmpty()) {
                throw new IllegalArgumentException("values must not be null and must include at least one entry");
            }
            return new NewIdentityAttributes(this);
        }
    }

    public static final class NewIdentityAttributes {
        private final String name;
        private List<String> values;

        private NewIdentityAttributes(NewIdentityAttributesBuilder builder) {
            this.name = builder.name;
            this.values = builder.values;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    public static final class X509CredentialMapperBuilder {
        private String digestFrom;
        private String digestAlgorithm;
        private String certificateFrom;
        private String serialNumberFrom;
        private String subjectDnFrom;

        public X509CredentialMapperBuilder digestFrom(String digestFrom) {
            this.digestFrom = digestFrom;
            return this;
        }

        public X509CredentialMapperBuilder digestAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        public X509CredentialMapperBuilder certificateFrom(String certificateFrom) {
            this.certificateFrom = certificateFrom;
            return this;
        }

        public X509CredentialMapperBuilder serialNumberFrom(String serialNumberFrom) {
            this.serialNumberFrom = serialNumberFrom;
            return this;
        }

        public X509CredentialMapperBuilder subjectDnFrom(String subjectDnFrom) {
            this.subjectDnFrom = subjectDnFrom;
            return this;
        }

        public X509CredentialMapper build() {
            return new X509CredentialMapper(this);
        }
    }

    public static final class X509CredentialMapper {
        private final String digestFrom;
        private final String digestAlgorithm;
        private final String certificateFrom;
        private final String serialNumberFrom;
        private final String subjectDnFrom;

        private X509CredentialMapper(X509CredentialMapperBuilder builder) {
            this.digestFrom = builder.digestFrom;
            this.digestAlgorithm = builder.digestAlgorithm;
            this.certificateFrom = builder.certificateFrom;
            this.serialNumberFrom = builder.serialNumberFrom;
            this.subjectDnFrom = builder.subjectDnFrom;
        }

        public String getDigestFrom() {
            return this.digestFrom;
        }

        public String getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public String getCertificateFrom() {
            return this.certificateFrom;
        }

        public String getSerialNumberFrom() {
            return this.serialNumberFrom;
        }

        public String getSubjectDnFrom() {
            return this.subjectDnFrom;
        }
    }

    public static final class OtpCredentialMapperBuilder {
        private String algorithmFrom;
        private String hashFrom;
        private String seedFrom;
        private String sequenceFrom;

        public OtpCredentialMapperBuilder algorithmFrom(String algorithmFrom) {
            this.algorithmFrom = algorithmFrom;
            return this;
        }

        public OtpCredentialMapperBuilder hashFrom(String hashFrom) {
            this.hashFrom = hashFrom;
            return this;
        }

        public OtpCredentialMapperBuilder seedFrom(String seedFrom) {
            this.seedFrom = seedFrom;
            return this;
        }

        public OtpCredentialMapperBuilder sequenceFrom(String sequenceFrom) {
            this.sequenceFrom = sequenceFrom;
            return this;
        }

        public OtpCredentialMapper build() {
            if (this.algorithmFrom == null || this.algorithmFrom.isEmpty()) {
                throw new IllegalArgumentException("identity-mapping.otp-credential-mapper.algorithm-from must not be null and must have a minimum length of 1 characters");
            }
            if (this.hashFrom == null || this.hashFrom.isEmpty()) {
                throw new IllegalArgumentException("identity-mapping.otp-credential-mapper.hash-from must not be null and must have a minimum length of 1 characters");
            }
            if (this.seedFrom == null || this.seedFrom.isEmpty()) {
                throw new IllegalArgumentException("identity-mapping.otp-credential-mapper.seed-from must not be null and must have a minimum length of 1 characters");
            }
            if (this.sequenceFrom == null || this.sequenceFrom.isEmpty()) {
                throw new IllegalArgumentException("identity-mapping.otp-credential-mapper.sequence-from must not be null and must have a minimum length of 1 characters");
            }
            return new OtpCredentialMapper(this);
        }
    }

    public static final class OtpCredentialMapper {
        private final String algorithmFrom;
        private final String hashFrom;
        private final String seedFrom;
        private final String sequenceFrom;

        private OtpCredentialMapper(OtpCredentialMapperBuilder builder) {
            this.algorithmFrom = builder.algorithmFrom;
            this.hashFrom = builder.hashFrom;
            this.seedFrom = builder.seedFrom;
            this.sequenceFrom = builder.sequenceFrom;
        }

        public String getAlgorithmFrom() {
            return this.algorithmFrom;
        }

        public String getHashFrom() {
            return this.hashFrom;
        }

        public String getSeedFrom() {
            return this.seedFrom;
        }

        public String getSequenceFrom() {
            return this.sequenceFrom;
        }
    }

    public static final class UserPasswordMapperBuilder {
        private String from;
        private Boolean writable;
        private Boolean verifiable;

        public UserPasswordMapperBuilder from(String from) {
            this.from = from;
            return this;
        }

        public UserPasswordMapperBuilder writable(Boolean writable) {
            this.writable = writable;
            return this;
        }

        public UserPasswordMapperBuilder verifiable(Boolean verifiable) {
            this.verifiable = verifiable;
            return this;
        }

        public UserPasswordMapper build() {
            if (this.from == null || this.from.isEmpty()) {
                throw new IllegalArgumentException("identity-mapping.user-password-mapper.from must not be null and must have a minimum length of 1 characters");
            }
            return new UserPasswordMapper(this);
        }
    }

    public static final class UserPasswordMapper {
        private final String from;
        private final Boolean writable;
        private final Boolean verifiable;

        private UserPasswordMapper(UserPasswordMapperBuilder builder) {
            this.from = builder.from;
            this.writable = builder.writable;
            this.verifiable = builder.verifiable;
        }

        public String getFrom() {
            return this.from;
        }

        public Boolean getWritable() {
            return this.writable;
        }

        public Boolean getVerifiable() {
            return this.verifiable;
        }
    }

    public static final class AttributeMappingBuilder {
        private String from;
        private String to;
        private String filter;
        private String filterBaseDn;
        private String extractRdn;
        private Boolean searchRecursive;
        private Integer roleRecursion;
        private String roleRecursionName;
        private String reference;

        public AttributeMappingBuilder from(String from) {
            this.from = from;
            return this;
        }

        public AttributeMappingBuilder to(String to) {
            this.to = to;
            return this;
        }

        public AttributeMappingBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public AttributeMappingBuilder filterBaseDn(String filterBaseDn) {
            this.filterBaseDn = filterBaseDn;
            return this;
        }

        public AttributeMappingBuilder extractRdn(String extractRdn) {
            this.extractRdn = extractRdn;
            return this;
        }

        public AttributeMappingBuilder searchRecursive(Boolean searchRecursive) {
            this.searchRecursive = searchRecursive;
            return this;
        }

        public AttributeMappingBuilder roleRecursion(Integer roleRecursion) {
            this.roleRecursion = roleRecursion;
            return this;
        }

        public AttributeMappingBuilder roleRecursionName(String roleRecursionName) {
            this.roleRecursionName = roleRecursionName;
            return this;
        }

        public AttributeMappingBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public AttributeMapping build() {
            return new AttributeMapping(this);
        }
    }

    public static final class AttributeMapping {
        private final String from;
        private final String to;
        private final String filter;
        private final String filterBaseDn;
        private final String extractRdn;
        private final Boolean searchRecursive;
        private final Integer roleRecursion;
        private final String roleRecursionName;
        private final String reference;

        private AttributeMapping(AttributeMappingBuilder builder) {
            this.from = builder.from;
            this.to = builder.to;
            this.filter = builder.filter;
            this.filterBaseDn = builder.filterBaseDn;
            this.extractRdn = builder.extractRdn;
            this.searchRecursive = builder.searchRecursive;
            this.roleRecursion = builder.roleRecursion;
            this.roleRecursionName = builder.roleRecursionName;
            this.reference = builder.reference;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getFilter() {
            return this.filter;
        }

        public String getFilterBaseDn() {
            return this.filterBaseDn;
        }

        public String getExtractRdn() {
            return this.extractRdn;
        }

        public Boolean getSearchRecursive() {
            return this.searchRecursive;
        }

        public Integer getRoleRecursion() {
            return this.roleRecursion;
        }

        public String getRoleRecursionName() {
            return this.roleRecursionName;
        }

        public String getReference() {
            return this.reference;
        }
    }

    public static final class IdentityMappingBuilder {
        private String rdnIdentifier;
        private String searchBaseDn;
        private Boolean useRecursiveSearch;
        private String filterName;
        private String iteratorFilter;
        private String newIdentityParentDn;
        private List<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
        private UserPasswordMapper userPasswordMapper;
        private OtpCredentialMapper otpCredentialMapper;
        private X509CredentialMapper x509CredentialMapper;
        private List<NewIdentityAttributes> newIdentityAttributes = new ArrayList<NewIdentityAttributes>();

        public IdentityMappingBuilder rdnIdentifier(String rdnIdentifier) {
            this.rdnIdentifier = rdnIdentifier;
            return this;
        }

        public IdentityMappingBuilder searchBaseDn(String searchBaseDn) {
            this.searchBaseDn = searchBaseDn;
            return this;
        }

        public IdentityMappingBuilder useRecursiveSearch(Boolean useRecursiveSearch) {
            this.useRecursiveSearch = useRecursiveSearch;
            return this;
        }

        public IdentityMappingBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public IdentityMappingBuilder iteratorFilter(String iteratorFilter) {
            this.iteratorFilter = iteratorFilter;
            return this;
        }

        public IdentityMappingBuilder newIdentityParentDn(String newIdentityParentDn) {
            this.newIdentityParentDn = newIdentityParentDn;
            return this;
        }

        public IdentityMappingBuilder addAttributeMappings(AttributeMapping ... attributeMappings) {
            if (attributeMappings == null) {
                throw new IllegalArgumentException("AttributeMappings added to ldap-realm must not be null");
            }
            Collections.addAll(this.attributeMappings, attributeMappings);
            return this;
        }

        public IdentityMappingBuilder userPasswordMapper(UserPasswordMapper userPasswordMapper) {
            this.userPasswordMapper = userPasswordMapper;
            return this;
        }

        public IdentityMappingBuilder otpCredentialMapper(OtpCredentialMapper otpCredentialMapper) {
            this.otpCredentialMapper = otpCredentialMapper;
            return this;
        }

        public IdentityMappingBuilder x509CredentialMapper(X509CredentialMapper x509CredentialMapper) {
            this.x509CredentialMapper = x509CredentialMapper;
            return this;
        }

        public IdentityMappingBuilder addNewIdentityAttributes(NewIdentityAttributes ... newIdentityAttributes) {
            if (newIdentityAttributes == null) {
                throw new IllegalArgumentException("NewIdentityAttributes added to ldap-realm must not be null");
            }
            Collections.addAll(this.newIdentityAttributes, newIdentityAttributes);
            return this;
        }

        public IdentityMapping build() {
            if (this.rdnIdentifier == null || this.rdnIdentifier.isEmpty()) {
                throw new IllegalArgumentException("rdn-identifier must not be null and must have a minimum length of 1 characters");
            }
            return new IdentityMapping(this);
        }
    }

    public static final class IdentityMapping {
        private final String rdnIdentifier;
        private final String searchBaseDn;
        private final Boolean useRecursiveSearch;
        private final String filterName;
        private final String iteratorFilter;
        private final String newIdentityParentDn;
        private final List<AttributeMapping> attributeMappings;
        private final UserPasswordMapper userPasswordMapper;
        private final OtpCredentialMapper otpCredentialMapper;
        private final X509CredentialMapper x509CredentialMapper;
        private final List<NewIdentityAttributes> newIdentityAttributes;

        private IdentityMapping(IdentityMappingBuilder builder) {
            this.rdnIdentifier = builder.rdnIdentifier;
            this.searchBaseDn = builder.searchBaseDn;
            this.useRecursiveSearch = builder.useRecursiveSearch;
            this.filterName = builder.filterName;
            this.iteratorFilter = builder.iteratorFilter;
            this.newIdentityParentDn = builder.newIdentityParentDn;
            this.attributeMappings = builder.attributeMappings;
            this.userPasswordMapper = builder.userPasswordMapper;
            this.otpCredentialMapper = builder.otpCredentialMapper;
            this.newIdentityAttributes = builder.newIdentityAttributes;
            this.x509CredentialMapper = builder.x509CredentialMapper;
        }

        public String getRdnIdentifier() {
            return this.rdnIdentifier;
        }

        public String getSearchBaseDn() {
            return this.searchBaseDn;
        }

        public Boolean getUseRecursiveSearch() {
            return this.useRecursiveSearch;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getIteratorFilter() {
            return this.iteratorFilter;
        }

        public String getNewIdentityParentDn() {
            return this.newIdentityParentDn;
        }

        public List<AttributeMapping> getAttributeMappings() {
            return this.attributeMappings;
        }

        public UserPasswordMapper getUserPasswordMapper() {
            return this.userPasswordMapper;
        }

        public OtpCredentialMapper getOtpCredentialMapper() {
            return this.otpCredentialMapper;
        }

        public X509CredentialMapper getX509CredentialMapper() {
            return this.x509CredentialMapper;
        }

        public List<NewIdentityAttributes> getNewIdentityAttributes() {
            return this.newIdentityAttributes;
        }
    }

    public static final class Builder {
        private final String name;
        private String dirContext;
        private Boolean directVerification;
        private Boolean allowBlankPassword;
        private IdentityMapping identityMapping;
        private boolean replaceExisting;

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the ldap-realm must be specified as non null value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the ldap-realm must not be empty value");
            }
            this.name = name;
        }

        public Builder dirContext(String dirContext) {
            this.dirContext = dirContext;
            return this;
        }

        public Builder directVerification(Boolean directVerification) {
            this.directVerification = directVerification;
            return this;
        }

        public Builder allowBlankPassword(Boolean allowBlankPassword) {
            this.allowBlankPassword = allowBlankPassword;
            return this;
        }

        public Builder identityMapping(IdentityMapping identityMapping) {
            this.identityMapping = identityMapping;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddLdapRealm build() {
            if (this.dirContext == null || this.dirContext.isEmpty()) {
                throw new IllegalArgumentException("dir-context must not be null and must have a minimum length of 1 characters");
            }
            if (this.identityMapping == null) {
                throw new IllegalArgumentException("identity-mapping must not be null");
            }
            return new AddLdapRealm(this);
        }
    }
}

