/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.components;

import java.io.IOException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.security.services.PageService;
import org.tynamo.security.services.SecurityService;

public class LoginForm {
    private static final Logger logger = LoggerFactory.getLogger(LoginForm.class);
    @Property
    private String tynamoLogin;
    @Property
    private String tynamoPassword;
    @Property
    private boolean tynamoRememberMe;
    @Persist(value="flash")
    private String loginMessage;
    @Inject
    private Response response;
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    private SecurityService securityService;
    @Inject
    private PageService pageService;
    @Inject
    private Cookies cookies;
    @Inject
    @Symbol(value="security.redirecttosavedurl")
    private boolean redirectToSavedUrl;

    public Object onActionFromTynamoLoginForm() throws IOException {
        Subject currentUser = this.securityService.getSubject();
        if (currentUser == null) {
            throw new IllegalStateException("Subject can`t be null");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(this.tynamoLogin, this.tynamoPassword);
        token.setRememberMe(this.tynamoRememberMe);
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException e) {
            this.loginMessage = "Account not exists";
            return null;
        }
        catch (IncorrectCredentialsException e) {
            this.loginMessage = "Wrong password";
            return null;
        }
        catch (LockedAccountException e) {
            this.loginMessage = "Account locked";
            return null;
        }
        catch (AuthenticationException e) {
            this.loginMessage = "Authentication Error";
            return null;
        }
        if (this.redirectToSavedUrl) {
            String requestUri = this.pageService.getSuccessPage();
            if (!requestUri.startsWith("/")) {
                requestUri = "/" + requestUri;
            }
            this.pageService.redirectToSavedRequest(requestUri);
            return null;
        }
        return this.pageService.getSuccessPage();
    }

    public void setLoginMessage(String loginMessage) {
        this.loginMessage = loginMessage;
    }

    public String getLoginMessage() {
        if (StringUtils.hasText((String)this.loginMessage)) {
            return this.loginMessage;
        }
        return " ";
    }
}

