/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security;

import java.io.IOException;
import java.util.List;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.tynamo.security.services.ClassInterceptorsCache;
import org.tynamo.security.services.PageService;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

public class SecurityComponentRequestFilter
implements ComponentRequestFilter {
    private final ComponentClassResolver resolver;
    private final ClassInterceptorsCache classInterceptorsCache;
    private final String loginClassName;
    private final String unauthorizedClassName;

    public SecurityComponentRequestFilter(PageService pageService, ComponentClassResolver resolver, ClassInterceptorsCache classInterceptorsCache) {
        this.resolver = resolver;
        this.classInterceptorsCache = classInterceptorsCache;
        this.loginClassName = resolver.resolvePageNameToClassName(pageService.getLoginPage());
        this.unauthorizedClassName = resolver.resolvePageNameToClassName(pageService.getUnauthorizedPage());
    }

    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        this.checkInternal(parameters.getActivePageName());
        handler.handleComponentEvent(parameters);
    }

    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        this.checkInternal(parameters.getLogicalPageName());
        handler.handlePageRender(parameters);
    }

    private void checkInternal(String logicalPageName) {
        String className;
        List<SecurityInterceptor> interceptors;
        String pageClassName = this.resolver.resolvePageNameToClassName(logicalPageName);
        if (!pageClassName.equals(this.loginClassName) && !pageClassName.equals(this.unauthorizedClassName) && (interceptors = this.classInterceptorsCache.get(className = this.resolver.resolvePageNameToClassName(logicalPageName))) != null) {
            for (SecurityInterceptor interceptor : interceptors) {
                interceptor.intercept();
            }
        }
    }
}

