/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ext;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptScanner;
import org.testcontainers.ext.ScriptSplitter;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public abstract class ScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtils.class);
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";

    private ScriptUtils() {
    }

    public static void splitSqlScript(String resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) {
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)script), "script must not be null or empty");
        ScriptUtils.checkArgument(separator != null, "separator must not be null");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)commentPrefix), "commentPrefix must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)blockCommentStartDelimiter), "blockCommentStartDelimiter must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)blockCommentEndDelimiter), "blockCommentEndDelimiter must not be null or empty");
        new ScriptSplitter(new ScriptScanner(resource, script, separator, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter), statements).split();
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        return ScriptUtils.containsSqlScriptDelimiters("", script, DEFAULT_COMMENT_PREFIX, delim, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static boolean containsSqlScriptDelimiters(String scriptPath, String script, String commentPrefix, String delim, String blockCommentStartDelimiter, String blockCommentEndDelimiter) {
        ScriptScanner.Lexem l;
        ScriptScanner scanner = new ScriptScanner(scriptPath, script, delim, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter);
        while ((l = scanner.next()) != ScriptScanner.Lexem.EOF) {
            if (!ScriptScanner.Lexem.SEPARATOR.equals((Object)l)) continue;
            return true;
        }
        return false;
    }

    public static void runInitScript(DatabaseDelegate databaseDelegate, String initScriptPath) {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(initScriptPath);
            if (resource == null && (resource = ScriptUtils.class.getClassLoader().getResource(initScriptPath)) == null) {
                LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
            }
            String scripts = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            ScriptUtils.executeDatabaseScript(databaseDelegate, initScriptPath, scripts);
        }
        catch (IOException e) {
            LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
            throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath, e);
        }
        catch (ScriptException e) {
            LOGGER.error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
            throw new UncategorizedScriptException("Error while executing init script: " + initScriptPath, e);
        }
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script) throws ScriptException {
        ScriptUtils.executeDatabaseScript(databaseDelegate, scriptPath, script, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executing database script from " + scriptPath);
            }
            long startTime = System.nanoTime();
            LinkedList<String> statements = new LinkedList<String>();
            if (separator == null) {
                separator = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!ScriptUtils.containsSqlScriptDelimiters(scriptPath, script, commentPrefix, separator, blockCommentStartDelimiter, blockCommentEndDelimiter)) {
                separator = FALLBACK_STATEMENT_SEPARATOR;
            }
            ScriptUtils.splitSqlScript(scriptPath, script, separator, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            try (DatabaseDelegate closeableDelegate = databaseDelegate;){
                closeableDelegate.execute(statements, scriptPath, continueOnError, ignoreFailedDrops);
            }
            long elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executed database script from " + scriptPath + " in " + elapsedTime + " ms.");
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + script + "]", ex);
        }
    }

    public static class UncategorizedScriptException
    extends RuntimeException {
        public UncategorizedScriptException(String s, Exception ex) {
            super(s, ex);
        }
    }

    public static class ScriptStatementFailedException
    extends RuntimeException {
        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath) {
            this(statement, lineNumber, scriptPath, null);
        }

        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath, Exception ex) {
            super(String.format("Script execution failed (%s:%d): %s", scriptPath, lineNumber, statement), ex);
        }
    }

    public static class ScriptParseException
    extends RuntimeException {
        public ScriptParseException(String format, String scriptPath) {
            super(String.format(format, scriptPath));
        }
    }

    public static class ScriptLoadException
    extends RuntimeException {
        public ScriptLoadException(String message) {
            super(message);
        }

        public ScriptLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

