/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.maven.plugins.sass;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tautua.maven.plugins.sass.Gem;
import org.tautua.maven.plugins.sass.LoggingCallback;
import org.tautua.maven.plugins.sass.RubygemsOptions;
import org.tautua.maven.plugins.sass.SassOptions;

public abstract class SassMojo
extends AbstractMojo {
    @Parameter
    private RubygemsOptions rubygemsOptions = new RubygemsOptions();
    @Parameter
    private SassOptions sassOptions = new SassOptions();

    protected void run(String scriptpath) throws ScriptException {
        System.setProperty("org.jruby.embed.localcontext.scope", "threadsafe");
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine jruby = engineManager.getEngineByName("jruby");
        LoggingCallback callback = new LoggingCallback(this.getLog());
        if (this.rubygemsOptions.findGem("sass") == null) {
            this.rubygemsOptions.getGems().add(new Gem("sass"));
        }
        jruby.put("$rubygems_options", this.rubygemsOptions);
        jruby.put("$sass_options", this.sassOptions);
        jruby.put("$callback", callback);
        jruby.put("$logger", this.getLog());
        jruby.eval(this.getScriptReader(scriptpath));
    }

    private Reader getScriptReader(String scriptpath) {
        InputStreamReader environment = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/environment.rb"));
        InputStreamReader specific = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(scriptpath));
        StringWriter writer = new StringWriter();
        try {
            SassMojo.transfer(environment, writer);
            writer.append("\n");
            SassMojo.transfer(specific, writer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new StringReader(writer.toString());
    }

    public static void transfer(Reader in, Writer out) throws IOException {
        int ch;
        while ((ch = in.read()) != -1) {
            out.append((char)ch);
        }
    }
}

