/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ContentNegotiatingViewResolver.class);
    private int order = Integer.MIN_VALUE;
    private ContentNegotiationManager contentNegotiationManager;
    private ContentNegotiationManagerFactoryBean cnManagerFactoryBean = new ContentNegotiationManagerFactoryBean();
    private boolean useNotAcceptableStatusCode = false;
    private List<View> defaultViews;
    private List<ViewResolver> viewResolvers;
    private static final View NOT_ACCEPTABLE_VIEW = new View(){

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
            response.setStatus(406);
        }
    };

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Deprecated
    public void setFavorPathExtension(boolean favorPathExtension) {
        this.cnManagerFactoryBean.setFavorParameter(favorPathExtension);
    }

    @Deprecated
    public void setUseJaf(boolean useJaf) {
        this.cnManagerFactoryBean.setUseJaf(useJaf);
    }

    @Deprecated
    public void setFavorParameter(boolean favorParameter) {
        this.cnManagerFactoryBean.setFavorParameter(favorParameter);
    }

    @Deprecated
    public void setParameterName(String parameterName) {
        this.cnManagerFactoryBean.setParameterName(parameterName);
    }

    @Deprecated
    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.cnManagerFactoryBean.setIgnoreAcceptHeader(ignoreAcceptHeader);
    }

    @Deprecated
    public void setMediaTypes(Map<String, String> mediaTypes) {
        if (mediaTypes != null) {
            Properties props = new Properties();
            props.putAll(mediaTypes);
            this.cnManagerFactoryBean.setMediaTypes(props);
        }
    }

    @Deprecated
    public void setDefaultContentType(MediaType defaultContentType) {
        this.cnManagerFactoryBean.setDefaultContentType(defaultContentType);
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    protected void initServletContext(ServletContext servletContext) {
        Collection matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ViewResolver.class).values();
        if (this.viewResolvers == null) {
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        } else {
            for (int i = 0; i < this.viewResolvers.size(); ++i) {
                if (matchingBeans.contains(this.viewResolvers.get(i))) continue;
                String name = this.viewResolvers.get(i).getClass().getName() + i;
                this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)this.viewResolvers.get(i), name);
            }
        }
        if (this.viewResolvers.isEmpty()) {
            logger.warn((Object)"Did not find any ViewResolvers to delegate to; please configure them using the 'viewResolvers' property on the ContentNegotiatingViewResolver");
        }
        OrderComparator.sort(this.viewResolvers);
        this.cnManagerFactoryBean.setServletContext(servletContext);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.contentNegotiationManager == null) {
            this.cnManagerFactoryBean.afterPropertiesSet();
            this.contentNegotiationManager = this.cnManagerFactoryBean.getObject();
        }
    }

    @Override
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        List<View> candidateViews;
        View bestView;
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)attrs);
        List<MediaType> requestedMediaTypes = this.getMediaTypes(((ServletRequestAttributes)attrs).getRequest());
        if (requestedMediaTypes != null && (bestView = this.getBestView(candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes), requestedMediaTypes, attrs)) != null) {
            return bestView;
        }
        if (this.useNotAcceptableStatusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No acceptable view found; returning 406 (Not Acceptable) status code");
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        logger.debug((Object)"No acceptable view found; returning null");
        return null;
    }

    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        try {
            ServletWebRequest webRequest = new ServletWebRequest(request);
            List acceptableMediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)webRequest);
            List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(request);
            LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
            for (MediaType acceptable : acceptableMediaTypes) {
                for (MediaType producible : producibleMediaTypes) {
                    if (!acceptable.isCompatibleWith(producible)) continue;
                    compatibleMediaTypes.add(this.getMostSpecificMediaType(acceptable, producible));
                }
            }
            ArrayList<MediaType> selectedMediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
            MediaType.sortBySpecificityAndQuality(selectedMediaTypes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested media types are " + selectedMediaTypes + " based on Accept header types " + "and producible media types " + producibleMediaTypes + ")"));
            }
            return selectedMediaTypes;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            return null;
        }
    }

    private List<MediaType> getProducibleMediaTypes(HttpServletRequest request) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceType = produceType.copyQualityValue(acceptType)) < 0 ? acceptType : produceType;
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view != null) {
                candidateViews.add(view);
            }
            for (MediaType requestedMediaType : requestedMediaTypes) {
                List extensions = this.contentNegotiationManager.resolveFileExtensions(requestedMediaType);
                for (String extension : extensions) {
                    String viewNameWithExtension = viewName + "." + extension;
                    view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                    if (view == null) continue;
                    candidateViews.add(view);
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes, RequestAttributes attrs) {
        for (View candidateView : candidateViews) {
            SmartView smartView;
            if (!(candidateView instanceof SmartView) || !(smartView = (SmartView)candidateView).isRedirectView()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning redirect view [" + candidateView + "]"));
            }
            return candidateView;
        }
        for (MediaType mediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText((String)candidateView.getContentType()) || !mediaType.isCompatibleWith(candidateContentType = MediaType.parseMediaType((String)candidateView.getContentType()))) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Returning [" + candidateView + "] based on requested media type '" + mediaType + "'"));
                }
                attrs.setAttribute(View.SELECTED_CONTENT_TYPE, (Object)mediaType, 0);
                return candidateView;
            }
        }
        return null;
    }
}

