/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.context.PortletContextResourceLoader;
import org.springframework.web.portlet.context.StandardPortletEnvironment;

public abstract class GenericPortletBean
extends GenericPortlet
implements EnvironmentAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set<String> requiredProperties = new HashSet<String>();
    private Environment environment = new StandardPortletEnvironment();

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws PortletException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing portlet '" + this.getPortletName() + "'"));
        }
        try {
            PortletConfigPropertyValues pvs = new PortletConfigPropertyValues(this.getPortletConfig(), this.requiredProperties);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)((Object)this));
            PortletContextResourceLoader resourceLoader = new PortletContextResourceLoader(this.getPortletContext());
            bw.registerCustomEditor(Resource.class, (PropertyEditor)new ResourceEditor((ResourceLoader)resourceLoader, (PropertyResolver)this.environment));
            this.initBeanWrapper(bw);
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (BeansException ex) {
            this.logger.error((Object)("Failed to set bean properties on portlet '" + this.getPortletName() + "'"), (Throwable)ex);
            throw ex;
        }
        this.initPortletBean();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Portlet '" + this.getPortletName() + "' configured successfully"));
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final String getPortletName() {
        return this.getPortletConfig() != null ? this.getPortletConfig().getPortletName() : null;
    }

    public final PortletContext getPortletContext() {
        return this.getPortletConfig() != null ? this.getPortletConfig().getPortletContext() : null;
    }

    protected void initPortletBean() throws PortletException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortletConfigPropertyValues
    extends MutablePropertyValues {
        private PortletConfigPropertyValues(PortletConfig config, Set<String> requiredProperties) throws PortletException {
            HashSet<String> missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet<String>(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, (Object)value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new PortletException("Initialization from PortletConfig for portlet '" + config.getPortletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, (String)", "));
            }
        }
    }
}

