/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

class ToStringVisitor
implements RouterFunctions.Visitor {
    private static final String NEW_LINE = System.getProperty("line.separator", "\\n");
    private final StringBuilder builder = new StringBuilder();
    private int indent = 0;

    ToStringVisitor() {
    }

    @Override
    public void startNested(RequestPredicate predicate) {
        this.indent();
        this.builder.append(predicate);
        this.builder.append(" => {");
        this.builder.append(NEW_LINE);
        ++this.indent;
    }

    @Override
    public void endNested(RequestPredicate predicate) {
        --this.indent;
        this.indent();
        this.builder.append('}');
        this.builder.append(NEW_LINE);
    }

    @Override
    public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
        this.indent();
        this.builder.append(predicate);
        this.builder.append(" -> ");
        this.builder.append(handlerFunction);
        this.builder.append(NEW_LINE);
    }

    @Override
    public void resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        this.indent();
        this.builder.append(lookupFunction);
        this.builder.append(NEW_LINE);
    }

    @Override
    public void unknown(RouterFunction<?> routerFunction) {
        this.indent();
        this.builder.append(routerFunction);
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.builder.append(' ');
        }
    }

    public String toString() {
        String result = this.builder.toString();
        if (result.endsWith(NEW_LINE)) {
            result = result.substring(0, result.length() - NEW_LINE.length());
        }
        return result;
    }
}

