/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.htmlunit.ForwardRequestPostProcessor;
import org.springframework.test.web.servlet.htmlunit.HtmlUnitRequestBuilder;
import org.springframework.test.web.servlet.htmlunit.MockWebResponseBuilder;
import org.springframework.util.Assert;

public final class MockMvcWebConnection
implements WebConnection {
    private final Map<String, MockHttpSession> sessions = new HashMap<String, MockHttpSession>();
    private final MockMvc mockMvc;
    @Nullable
    private final String contextPath;
    private WebClient webClient;
    private static int MAX_FORWARDS = 100;

    public MockMvcWebConnection(MockMvc mockMvc, WebClient webClient) {
        this(mockMvc, webClient, "");
    }

    public MockMvcWebConnection(MockMvc mockMvc, WebClient webClient, @Nullable String contextPath) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        MockMvcWebConnection.validateContextPath(contextPath);
        this.webClient = webClient;
        this.mockMvc = mockMvc;
        this.contextPath = contextPath;
    }

    static void validateContextPath(@Nullable String contextPath) {
        if (contextPath == null || contextPath.isEmpty()) {
            return;
        }
        Assert.isTrue((boolean)contextPath.startsWith("/"), () -> "contextPath '" + contextPath + "' must start with '/'.");
        Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, () -> "contextPath '" + contextPath + "' must not end with '/'.");
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        this.webClient = webClient;
    }

    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        int forwards;
        long startTime = System.currentTimeMillis();
        HtmlUnitRequestBuilder requestBuilder = new HtmlUnitRequestBuilder(this.sessions, this.webClient, webRequest);
        requestBuilder.setContextPath(this.contextPath);
        MockHttpServletResponse httpServletResponse = this.getResponse(requestBuilder);
        String forwardedUrl = httpServletResponse.getForwardedUrl();
        for (forwards = 0; forwardedUrl != null && forwards < MAX_FORWARDS; ++forwards) {
            requestBuilder.setForwardPostProcessor(new ForwardRequestPostProcessor(forwardedUrl));
            httpServletResponse = this.getResponse(requestBuilder);
            forwardedUrl = httpServletResponse.getForwardedUrl();
        }
        if (forwards == MAX_FORWARDS) {
            throw new IllegalStateException("Forwarded more than " + forwards + " times in a row, potential infinite forward loop");
        }
        this.storeCookies(webRequest, httpServletResponse.getCookies());
        return new MockWebResponseBuilder(startTime, webRequest, httpServletResponse).build();
    }

    private MockHttpServletResponse getResponse(RequestBuilder requestBuilder) throws IOException {
        ResultActions resultActions;
        try {
            resultActions = this.mockMvc.perform(requestBuilder);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return resultActions.andReturn().getResponse();
    }

    private void storeCookies(WebRequest webRequest, javax.servlet.http.Cookie[] cookies) {
        Date now = new Date();
        CookieManager cookieManager = this.webClient.getCookieManager();
        for (javax.servlet.http.Cookie cookie : cookies) {
            Cookie toManage;
            Date expires;
            if (cookie.getDomain() == null) {
                cookie.setDomain(webRequest.getUrl().getHost());
            }
            if ((expires = (toManage = MockMvcWebConnection.createCookie(cookie)).getExpires()) == null || expires.after(now)) {
                cookieManager.addCookie(toManage);
                continue;
            }
            cookieManager.removeCookie(toManage);
        }
    }

    private static Cookie createCookie(javax.servlet.http.Cookie cookie) {
        Date expires = null;
        if (cookie.getMaxAge() > -1) {
            expires = new Date(System.currentTimeMillis() + (long)(cookie.getMaxAge() * 1000));
        }
        BasicClientCookie result = new BasicClientCookie(cookie.getName(), cookie.getValue());
        result.setDomain(cookie.getDomain());
        result.setComment(cookie.getComment());
        result.setExpiryDate(expires);
        result.setPath(cookie.getPath());
        result.setSecure(cookie.getSecure());
        if (cookie.isHttpOnly()) {
            result.setAttribute("httponly", "true");
        }
        return new Cookie((ClientCookie)result);
    }

    public void close() {
    }
}

