/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();

    public DirectFieldAccessor(Object target) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        this.target = target;
        ReflectionUtils.doWithFields(this.target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (!DirectFieldAccessor.this.fieldMap.containsKey(field.getName())) {
                    DirectFieldAccessor.this.fieldMap.put(field.getName(), field);
                }
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, target);
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    @Override
    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        Field field = this.fieldMap.get(propertyName);
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        Field field = this.fieldMap.get(propertyName);
        if (field != null) {
            return new TypeDescriptor(field);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        Field field = this.fieldMap.get(propertyName);
        if (field == null) {
            throw new NotReadablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible((Field)field);
            return field.get(this.target);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        Field field = this.fieldMap.get(propertyName);
        if (field == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Object oldValue = null;
        try {
            ReflectionUtils.makeAccessible((Field)field);
            oldValue = field.get(this.target);
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(field.getName(), oldValue, newValue, field.getType(), new TypeDescriptor(field));
            field.set(this.target, convertedValue);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field.getType(), (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field.getType(), (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field.getType(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field.getType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }
}

