/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    private boolean validating = true;
    private boolean namespaceAware = false;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);
    private EntityResolver entityResolver = null;
    private Class parserClass = class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser;

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        this.entityResolver = this.getResourceLoader() != null ? new ResourceEntityResolver(this.getResourceLoader()) : new BeansDtdResolver();
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setParserClass(Class parserClass) {
        if (this.parserClass == null || !(class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser).isAssignableFrom(parserClass)) {
            throw new IllegalArgumentException("parserClass must be an XmlBeanDefinitionParser");
        }
        this.parserClass = parserClass;
    }

    public int loadBeanDefinitions(Resource resource) throws BeansException {
        return this.loadBeanDefinitions(new EncodedResource(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeansException {
        int n;
        if (encodedResource == null) {
            throw new BeanDefinitionStoreException("Resource cannot be null: expected an XML file");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading XML bean definitions from " + encodedResource.getResource()));
        }
        InputStream inputStream = encodedResource.getResource().getInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            if (encodedResource.getEncoding() != null) {
                inputSource.setEncoding(encodedResource.getEncoding());
            }
            n = this.doLoadBeanDefinitions(inputSource, encodedResource.getResource());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("IOException parsing XML document from " + encodedResource.getResource(), ex);
            }
        }
        inputStream.close();
        return n;
    }

    public int loadBeanDefinitions(InputSource inputSource) throws BeansException {
        return this.loadBeanDefinitions(inputSource, "resource loaded through SAX InputSource");
    }

    public int loadBeanDefinitions(InputSource inputSource, String resourceDescription) throws BeansException {
        return this.doLoadBeanDefinitions(inputSource, (Resource)new DescriptiveResource(resourceDescription));
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeansException {
        try {
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using JAXP implementation [" + factory + "]"));
            }
            DocumentBuilder builder = this.createDocumentBuilder(factory);
            Document doc = builder.parse(inputSource);
            return this.registerBeanDefinitions(doc, resource);
        }
        catch (ParserConfigurationException ex) {
            throw new BeanDefinitionStoreException("Parser configuration exception parsing XML from " + resource, ex);
        }
        catch (SAXParseException ex) {
            throw new BeanDefinitionStoreException("Line " + ex.getLineNumber() + " in XML document from " + resource + " is invalid", ex);
        }
        catch (SAXException ex) {
            throw new BeanDefinitionStoreException("XML document from " + resource + " is invalid", ex);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("IOException parsing XML document from " + resource, ex);
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.validating);
        factory.setNamespaceAware(this.namespaceAware);
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (this.errorHandler != null) {
            docBuilder.setErrorHandler(this.errorHandler);
        }
        if (this.entityResolver != null) {
            docBuilder.setEntityResolver(this.entityResolver);
        }
        return docBuilder;
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        XmlBeanDefinitionParser parser = (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
        return parser.registerBeanDefinitions(this, doc, resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

