/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.ConnectInterceptor;
import org.springframework.social.connect.web.ConnectSupport;
import org.springframework.social.connect.web.DisconnectInterceptor;
import org.springframework.social.connect.web.HttpSessionSessionStrategy;
import org.springframework.social.connect.web.SessionStrategy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/connect"})
public class ConnectController
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(ConnectController.class);
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final ConnectionRepository connectionRepository;
    private final MultiValueMap<Class<?>, ConnectInterceptor<?>> connectInterceptors = new LinkedMultiValueMap();
    private final MultiValueMap<Class<?>, DisconnectInterceptor<?>> disconnectInterceptors = new LinkedMultiValueMap();
    private ConnectSupport connectSupport;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private String viewPath = "connect/";
    private SessionStrategy sessionStrategy = new HttpSessionSessionStrategy();
    private String applicationUrl = null;
    protected static final String DUPLICATE_CONNECTION_ATTRIBUTE = "social_addConnection_duplicate";
    protected static final String PROVIDER_ERROR_ATTRIBUTE = "social_provider_error";
    protected static final String AUTHORIZATION_ERROR_ATTRIBUTE = "social_authorization_error";

    @Inject
    public ConnectController(ConnectionFactoryLocator connectionFactoryLocator, ConnectionRepository connectionRepository) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connectionRepository = connectionRepository;
    }

    @Deprecated
    public void setInterceptors(List<ConnectInterceptor<?>> interceptors) {
        this.setConnectInterceptors(interceptors);
    }

    public void setConnectInterceptors(List<ConnectInterceptor<?>> interceptors) {
        for (ConnectInterceptor<?> interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void setDisconnectInterceptors(List<DisconnectInterceptor<?>> interceptors) {
        for (DisconnectInterceptor<?> interceptor : interceptors) {
            this.addDisconnectInterceptor(interceptor);
        }
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setViewPath(String viewPath) {
        this.viewPath = viewPath;
    }

    public void setSessionStrategy(SessionStrategy sessionStrategy) {
        this.sessionStrategy = sessionStrategy;
    }

    public void addInterceptor(ConnectInterceptor<?> interceptor) {
        Class serviceApiType = GenericTypeResolver.resolveTypeArgument(interceptor.getClass(), ConnectInterceptor.class);
        this.connectInterceptors.add((Object)serviceApiType, interceptor);
    }

    public void addDisconnectInterceptor(DisconnectInterceptor<?> interceptor) {
        Class serviceApiType = GenericTypeResolver.resolveTypeArgument(interceptor.getClass(), DisconnectInterceptor.class);
        this.disconnectInterceptors.add((Object)serviceApiType, interceptor);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String connectionStatus(NativeWebRequest request, Model model) {
        this.setNoCache(request);
        this.processFlash((WebRequest)request, model);
        MultiValueMap connections = this.connectionRepository.findAllConnections();
        model.addAttribute("providerIds", (Object)this.connectionFactoryLocator.registeredProviderIds());
        model.addAttribute("connectionMap", (Object)connections);
        return this.connectView();
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET})
    public String connectionStatus(@PathVariable String providerId, NativeWebRequest request, Model model) {
        this.setNoCache(request);
        this.processFlash((WebRequest)request, model);
        List connections = this.connectionRepository.findConnections(providerId);
        this.setNoCache(request);
        if (connections.isEmpty()) {
            return this.connectView(providerId);
        }
        model.addAttribute("connections", (Object)connections);
        return this.connectedView(providerId);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.POST})
    public RedirectView connect(@PathVariable String providerId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        this.preConnect(connectionFactory, (MultiValueMap<String, String>)parameters, (WebRequest)request);
        try {
            return new RedirectView(this.connectSupport.buildOAuthUrl(connectionFactory, request, (MultiValueMap<String, String>)parameters));
        }
        catch (Exception e) {
            this.sessionStrategy.setAttribute((RequestAttributes)request, PROVIDER_ERROR_ATTRIBUTE, e);
            return this.connectionStatusRedirect(providerId, request);
        }
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"oauth_token"})
    public RedirectView oauth1Callback(@PathVariable String providerId, NativeWebRequest request) {
        try {
            OAuth1ConnectionFactory connectionFactory = (OAuth1ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
            Connection<?> connection = this.connectSupport.completeConnection(connectionFactory, request);
            this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        }
        catch (Exception e) {
            this.sessionStrategy.setAttribute((RequestAttributes)request, PROVIDER_ERROR_ATTRIBUTE, e);
            logger.warn((Object)("Exception while handling OAuth1 callback (" + e.getMessage() + "). Redirecting to " + providerId + " connection status page."));
        }
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"code"})
    public RedirectView oauth2Callback(@PathVariable String providerId, NativeWebRequest request) {
        try {
            OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
            Connection<?> connection = this.connectSupport.completeConnection(connectionFactory, request);
            this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        }
        catch (Exception e) {
            this.sessionStrategy.setAttribute((RequestAttributes)request, PROVIDER_ERROR_ATTRIBUTE, e);
            logger.warn((Object)("Exception while handling OAuth2 callback (" + e.getMessage() + "). Redirecting to " + providerId + " connection status page."));
        }
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"error"})
    public RedirectView oauth2ErrorCallback(@PathVariable String providerId, @RequestParam(value="error") String error, @RequestParam(value="error_description", required=false) String errorDescription, @RequestParam(value="error_uri", required=false) String errorUri, NativeWebRequest request) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("error", error);
        if (errorDescription != null) {
            errorMap.put("errorDescription", errorDescription);
        }
        if (errorUri != null) {
            errorMap.put("errorUri", errorUri);
        }
        this.sessionStrategy.setAttribute((RequestAttributes)request, AUTHORIZATION_ERROR_ATTRIBUTE, errorMap);
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnections(@PathVariable String providerId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        this.preDisconnect(connectionFactory, (WebRequest)request);
        this.connectionRepository.removeConnections(providerId);
        this.postDisconnect(connectionFactory, (WebRequest)request);
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}/{providerUserId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnection(@PathVariable String providerId, @PathVariable String providerUserId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        this.preDisconnect(connectionFactory, (WebRequest)request);
        this.connectionRepository.removeConnection(new ConnectionKey(providerId, providerUserId));
        this.postDisconnect(connectionFactory, (WebRequest)request);
        return this.connectionStatusRedirect(providerId, request);
    }

    protected String connectView() {
        return this.getViewPath() + "status";
    }

    protected String connectView(String providerId) {
        return this.getViewPath() + providerId + "Connect";
    }

    protected String connectedView(String providerId) {
        return this.getViewPath() + providerId + "Connected";
    }

    protected RedirectView connectionStatusRedirect(String providerId, NativeWebRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String path = "/connect/" + providerId + this.getPathExtension(servletRequest);
        if (this.prependServletPath(servletRequest)) {
            path = servletRequest.getServletPath() + path;
        }
        return new RedirectView(path, true);
    }

    public void afterPropertiesSet() throws Exception {
        this.connectSupport = new ConnectSupport(this.sessionStrategy);
        if (this.applicationUrl != null) {
            this.connectSupport.setApplicationUrl(this.applicationUrl);
        }
    }

    private boolean prependServletPath(HttpServletRequest request) {
        return !this.urlPathHelper.getPathWithinServletMapping(request).equals("");
    }

    private String getPathExtension(HttpServletRequest request) {
        String fileName = WebUtils.extractFullFilenameFromUrlPath((String)request.getRequestURI());
        String extension = StringUtils.getFilenameExtension((String)fileName);
        return extension != null ? "." + extension : "";
    }

    private String getViewPath() {
        return this.viewPath;
    }

    private void addConnection(Connection<?> connection, ConnectionFactory<?> connectionFactory, WebRequest request) {
        try {
            this.connectionRepository.addConnection(connection);
            this.postConnect(connectionFactory, connection, request);
        }
        catch (DuplicateConnectionException e) {
            this.sessionStrategy.setAttribute((RequestAttributes)request, DUPLICATE_CONNECTION_ATTRIBUTE, (Object)e);
        }
    }

    private void preConnect(ConnectionFactory<?> connectionFactory, MultiValueMap<String, String> parameters, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.preConnect(connectionFactory, parameters, request);
        }
    }

    private void postConnect(ConnectionFactory<?> connectionFactory, Connection<?> connection, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.postConnect(connection, request);
        }
    }

    private void preDisconnect(ConnectionFactory<?> connectionFactory, WebRequest request) {
        for (DisconnectInterceptor<?> interceptor : this.interceptingDisconnectionsTo(connectionFactory)) {
            interceptor.preDisconnect(connectionFactory, request);
        }
    }

    private void postDisconnect(ConnectionFactory<?> connectionFactory, WebRequest request) {
        for (DisconnectInterceptor<?> interceptor : this.interceptingDisconnectionsTo(connectionFactory)) {
            interceptor.postDisconnect(connectionFactory, request);
        }
    }

    private List<ConnectInterceptor<?>> interceptingConnectionsTo(ConnectionFactory<?> connectionFactory) {
        Class serviceType = GenericTypeResolver.resolveTypeArgument(connectionFactory.getClass(), ConnectionFactory.class);
        List<ConnectInterceptor<?>> typedInterceptors = (List<ConnectInterceptor<?>>)this.connectInterceptors.get((Object)serviceType);
        if (typedInterceptors == null) {
            typedInterceptors = Collections.emptyList();
        }
        return typedInterceptors;
    }

    private List<DisconnectInterceptor<?>> interceptingDisconnectionsTo(ConnectionFactory<?> connectionFactory) {
        Class serviceType = GenericTypeResolver.resolveTypeArgument(connectionFactory.getClass(), ConnectionFactory.class);
        List<DisconnectInterceptor<?>> typedInterceptors = (List<DisconnectInterceptor<?>>)this.disconnectInterceptors.get((Object)serviceType);
        if (typedInterceptors == null) {
            typedInterceptors = Collections.emptyList();
        }
        return typedInterceptors;
    }

    private void processFlash(WebRequest request, Model model) {
        this.convertSessionAttributeToModelAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, request, model);
        this.convertSessionAttributeToModelAttribute(PROVIDER_ERROR_ATTRIBUTE, request, model);
        model.addAttribute(AUTHORIZATION_ERROR_ATTRIBUTE, this.sessionStrategy.getAttribute((RequestAttributes)request, AUTHORIZATION_ERROR_ATTRIBUTE));
        this.sessionStrategy.removeAttribute((RequestAttributes)request, AUTHORIZATION_ERROR_ATTRIBUTE);
    }

    private void convertSessionAttributeToModelAttribute(String attributeName, WebRequest request, Model model) {
        if (this.sessionStrategy.getAttribute((RequestAttributes)request, attributeName) != null) {
            model.addAttribute(attributeName, (Object)Boolean.TRUE);
            this.sessionStrategy.removeAttribute((RequestAttributes)request, attributeName);
        }
    }

    private void setNoCache(NativeWebRequest request) {
        HttpServletResponse response = (HttpServletResponse)request.getNativeResponse(HttpServletResponse.class);
        if (response != null) {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 1L);
            response.setHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
        }
    }
}

