/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.rsa.crypto;

/**
 * @author Dave Syer
 *
 */
public enum RsaAlgorithm {

	DEFAULT("RSA", 117), OAEP("RSA/ECB/OAEPPadding", 86);

	private String name;
	private int maxLength;

	private RsaAlgorithm(String name, int maxLength) {
		this.name = name;
		this.maxLength = maxLength;
	}

	public String getJceName() {
		return this.name;
	}

	public int getMaxLength() {
		return this.maxLength;
	}

}
