/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public class CompositeProducerInterceptor<K, V>
implements ProducerInterceptor<K, V>,
Closeable {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final List<ProducerInterceptor<K, V>> delegates = new ArrayList<ProducerInterceptor<K, V>>();

    @SafeVarargs
    public CompositeProducerInterceptor(ProducerInterceptor<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot have null entries");
        this.delegates.addAll(Arrays.asList(delegates));
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> record) {
        ProducerRecord interceptRecord = record;
        for (ProducerInterceptor interceptor : this.delegates) {
            try {
                interceptRecord = interceptor.onSend(interceptRecord);
            }
            catch (Exception e) {
                if (record != null) {
                    this.logger.warn((Throwable)e, () -> String.format("Error executing interceptor onSend callback for topic: %s, partition: %d", record.topic(), record.partition()));
                    continue;
                }
                this.logger.warn((Throwable)e, () -> "Error executing interceptor onSend callback: " + interceptor.toString());
            }
        }
        return interceptRecord;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        for (ProducerInterceptor interceptor : this.delegates) {
            try {
                interceptor.onAcknowledgement(metadata, exception);
            }
            catch (Exception e) {
                this.logger.warn((Throwable)e, () -> "Error executing interceptor onAcknowledgement callback: " + interceptor.toString());
            }
        }
    }

    @Override
    public void close() {
        for (ProducerInterceptor interceptor : this.delegates) {
            try {
                interceptor.close();
            }
            catch (Exception e) {
                this.logger.warn((Throwable)e, () -> "Failed to close producer interceptor: " + interceptor.toString());
            }
        }
    }

    public void configure(Map<String, ?> configs) {
        this.delegates.forEach(delegate -> delegate.configure(configs));
    }
}

