/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@BasePathAwareController
public class AlpsController {
    private final RepositoryRestConfiguration configuration;

    @Autowired
    public AlpsController(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"MetadataConfiguration must not be null");
        this.configuration = configuration;
    }

    @RequestMapping(value={"/profile/{repository}"}, method={RequestMethod.OPTIONS}, produces={"application/alps+json"})
    HttpEntity<?> alpsOptions() {
        this.verifyAlpsEnabled();
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/profile/{repository}"}, method={RequestMethod.GET}, produces={"*/*", "application/alps+json"})
    HttpEntity<RootResourceInformation> descriptor(RootResourceInformation information) {
        this.verifyAlpsEnabled();
        return new ResponseEntity((Object)information, (HttpStatusCode)HttpStatus.OK);
    }

    private void verifyAlpsEnabled() {
        if (!this.configuration.getMetadataConfiguration().alpsEnabled()) {
            throw new ResourceNotFoundException();
        }
    }
}

