/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.cache.support.NullValue;
import org.springframework.core.KotlinDetector;
import org.springframework.data.redis.serializer.JacksonObjectReader;
import org.springframework.data.redis.serializer.JacksonObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GenericJackson2JsonRedisSerializer
implements RedisSerializer<Object> {
    private final JacksonObjectReader reader;
    private final JacksonObjectWriter writer;
    private final Lazy<Boolean> defaultTypingEnabled;
    private final ObjectMapper mapper;
    private final TypeResolver typeResolver;

    public GenericJackson2JsonRedisSerializer() {
        this((String)null);
    }

    public GenericJackson2JsonRedisSerializer(@Nullable String typeHintPropertyName) {
        this(typeHintPropertyName, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public GenericJackson2JsonRedisSerializer(@Nullable String typeHintPropertyName, JacksonObjectReader reader, JacksonObjectWriter writer) {
        this(new ObjectMapper(), reader, writer, typeHintPropertyName);
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer(this.mapper, typeHintPropertyName);
        this.mapper.setDefaultTyping((com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder)GenericJackson2JsonRedisSerializer.createDefaultTypeResolverBuilder(this.getObjectMapper(), typeHintPropertyName));
    }

    public GenericJackson2JsonRedisSerializer(ObjectMapper mapper) {
        this(mapper, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public GenericJackson2JsonRedisSerializer(ObjectMapper mapper, JacksonObjectReader reader, JacksonObjectWriter writer) {
        this(mapper, reader, writer, null);
    }

    private GenericJackson2JsonRedisSerializer(ObjectMapper mapper, JacksonObjectReader reader, JacksonObjectWriter writer, @Nullable String typeHintPropertyName) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)reader, (String)"Reader must not be null");
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.defaultTypingEnabled = Lazy.of(() -> mapper.getSerializationConfig().getDefaultTyper(null) != null);
        this.typeResolver = GenericJackson2JsonRedisSerializer.newTypeResolver(mapper, typeHintPropertyName, this.defaultTypingEnabled);
    }

    private static TypeResolver newTypeResolver(ObjectMapper mapper, @Nullable String typeHintPropertyName, Lazy<Boolean> defaultTypingEnabled) {
        Lazy lazyTypeFactory = Lazy.of(() -> ((ObjectMapper)mapper).getTypeFactory());
        Lazy<String> lazyTypeHintPropertyName = typeHintPropertyName != null ? Lazy.of((Object)typeHintPropertyName) : GenericJackson2JsonRedisSerializer.newLazyTypeHintPropertyName(mapper, defaultTypingEnabled);
        return new TypeResolver(mapper, (Supplier<TypeFactory>)lazyTypeFactory, (Supplier<String>)lazyTypeHintPropertyName);
    }

    private static Lazy<String> newLazyTypeHintPropertyName(ObjectMapper mapper, Lazy<Boolean> defaultTypingEnabled) {
        Lazy<String> configuredTypeDeserializationPropertyName = GenericJackson2JsonRedisSerializer.getConfiguredTypeDeserializationPropertyName(mapper);
        Lazy resolvedLazyTypeHintPropertyName = Lazy.of(() -> (Boolean)defaultTypingEnabled.get() != false ? null : (String)configuredTypeDeserializationPropertyName.get());
        return resolvedLazyTypeHintPropertyName.or((Object)"@class");
    }

    private static Lazy<String> getConfiguredTypeDeserializationPropertyName(ObjectMapper mapper) {
        return Lazy.of(() -> {
            DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
            JavaType objectType = mapper.getTypeFactory().constructType(Object.class);
            TypeDeserializer typeDeserializer = deserializationConfig.getDefaultTyper(null).buildTypeDeserializer(deserializationConfig, objectType, Collections.emptyList());
            return typeDeserializer.getPropertyName();
        });
    }

    private static StdTypeResolverBuilder createDefaultTypeResolverBuilder(ObjectMapper objectMapper, @Nullable String typeHintPropertyName) {
        StdTypeResolverBuilder typer = TypeResolverBuilder.forEverything(objectMapper).init(JsonTypeInfo.Id.CLASS, null).inclusion(JsonTypeInfo.As.PROPERTY);
        if (StringUtils.hasText((String)typeHintPropertyName)) {
            typer = typer.typeProperty(typeHintPropertyName);
        }
        return typer;
    }

    public static GenericJackson2JsonRedisSerializerBuilder builder() {
        return new GenericJackson2JsonRedisSerializerBuilder();
    }

    public static void registerNullValueSerializer(ObjectMapper objectMapper, @Nullable String typeHintPropertyName) {
        objectMapper.registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new NullValueSerializer(typeHintPropertyName)));
    }

    protected ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    @Override
    public byte[] serialize(@Nullable Object value) throws SerializationException {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, value);
        }
        catch (IOException ex) {
            throw new SerializationException("Could not write JSON: %s".formatted(ex.getMessage()), ex);
        }
    }

    @Override
    public Object deserialize(@Nullable byte[] source) throws SerializationException {
        return this.deserialize(source, Object.class);
    }

    @Nullable
    public <T> T deserialize(@Nullable byte[] source, Class<T> type) throws SerializationException {
        Assert.notNull(type, (String)"Deserialization type must not be null; Please provide Object.class to make use of Jackson2 default typing.");
        if (SerializationUtils.isEmpty(source)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, source, this.resolveType(source, type));
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON:%s ".formatted(ex.getMessage()), ex);
        }
    }

    public GenericJackson2JsonRedisSerializer configure(Consumer<ObjectMapper> objectMapperConfigurer) {
        Assert.notNull(objectMapperConfigurer, (String)"Consumer used to configure and customize ObjectMapper must not be null");
        objectMapperConfigurer.accept(this.getObjectMapper());
        return this;
    }

    protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
        if (!type.equals(Object.class) || !((Boolean)this.defaultTypingEnabled.get()).booleanValue()) {
            return this.typeResolver.constructType(type);
        }
        return this.typeResolver.resolveType(source, type);
    }

    static class TypeResolver {
        private final ObjectMapper mapper;
        private final Supplier<TypeFactory> typeFactory;
        private final Supplier<String> hintName;

        TypeResolver(ObjectMapper mapper, Supplier<TypeFactory> typeFactory, Supplier<String> hintName) {
            this.mapper = mapper;
            this.typeFactory = typeFactory;
            this.hintName = hintName;
        }

        protected JavaType constructType(Class<?> type) {
            return this.typeFactory.get().constructType(type);
        }

        protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
            JsonNode root = this.readTree(source);
            JsonNode jsonNode = root.get(this.hintName.get());
            if (jsonNode instanceof TextNode && jsonNode.asText() != null) {
                return this.typeFactory.get().constructFromCanonical(jsonNode.asText());
            }
            return this.constructType(type);
        }

        private JsonNode readTree(byte[] source) throws IOException {
            JsonDeserializer deserializer = JsonNodeDeserializer.getDeserializer(JsonNode.class);
            DeserializationConfig cfg = this.mapper.getDeserializationConfig();
            try (JsonParser parser = this.createParser(source, cfg);){
                JsonToken t = parser.currentToken();
                if (t == null && (t = parser.nextToken()) == null) {
                    JsonNode jsonNode = cfg.getNodeFactory().missingNode();
                    return jsonNode;
                }
                DefaultDeserializationContext ctxt = new DefaultDeserializationContext.Impl((DeserializerFactory)BeanDeserializerFactory.instance).createInstance(cfg, parser, this.mapper.getInjectableValues());
                if (t == JsonToken.VALUE_NULL) {
                    NullNode nullNode = cfg.getNodeFactory().nullNode();
                    return nullNode;
                }
                JsonNode jsonNode = (JsonNode)deserializer.deserialize(parser, (DeserializationContext)ctxt);
                return jsonNode;
            }
        }

        private JsonParser createParser(byte[] source, DeserializationConfig cfg) throws IOException {
            JsonParser parser = this.mapper.createParser(source);
            cfg.initialize(parser);
            return parser;
        }
    }

    private static class TypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        static TypeResolverBuilder forEverything(ObjectMapper mapper) {
            return new TypeResolverBuilder(ObjectMapper.DefaultTyping.EVERYTHING, mapper.getPolymorphicTypeValidator());
        }

        public TypeResolverBuilder(ObjectMapper.DefaultTyping typing, PolymorphicTypeValidator polymorphicTypeValidator) {
            super(typing, polymorphicTypeValidator);
        }

        public ObjectMapper.DefaultTypeResolverBuilder withDefaultImpl(Class<?> defaultImpl) {
            return this;
        }

        public boolean useForType(JavaType javaType) {
            if (javaType.isJavaLangObject()) {
                return true;
            }
            if ((javaType = this.resolveArrayOrWrapper(javaType)).isEnumType() || ClassUtils.isPrimitiveOrWrapper((Class)javaType.getRawClass())) {
                return false;
            }
            if (javaType.isFinal() && !KotlinDetector.isKotlinType((Class)javaType.getRawClass()) && javaType.getRawClass().getPackageName().startsWith("java")) {
                return false;
            }
            return !TreeNode.class.isAssignableFrom(javaType.getRawClass());
        }

        private JavaType resolveArrayOrWrapper(JavaType type) {
            while (type.isArrayType()) {
                if (!(type = type.getContentType()).isReferenceType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            while (type.isReferenceType()) {
                if (!(type = type.getReferencedType()).isArrayType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            return type;
        }
    }

    public static class GenericJackson2JsonRedisSerializerBuilder {
        @Nullable
        private String typeHintPropertyName;
        private JacksonObjectReader reader = JacksonObjectReader.create();
        private JacksonObjectWriter writer = JacksonObjectWriter.create();
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private Boolean defaultTyping;
        private boolean registerNullValueSerializer = true;
        @Nullable
        private StdSerializer<NullValue> nullValueSerializer;

        private GenericJackson2JsonRedisSerializerBuilder() {
        }

        public GenericJackson2JsonRedisSerializerBuilder defaultTyping(boolean defaultTyping) {
            this.defaultTyping = defaultTyping;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder typeHintPropertyName(String typeHintPropertyName) {
            Assert.hasText((String)typeHintPropertyName, (String)"Type hint property name must bot be null or empty");
            this.typeHintPropertyName = typeHintPropertyName;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder reader(JacksonObjectReader reader) {
            Assert.notNull((Object)reader, (String)"JacksonObjectReader must not be null");
            this.reader = reader;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder writer(JacksonObjectWriter writer) {
            Assert.notNull((Object)writer, (String)"JacksonObjectWriter must not be null");
            this.writer = writer;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder nullValueSerializer(StdSerializer<NullValue> nullValueSerializer) {
            Assert.notNull(nullValueSerializer, (String)"Null value serializer must not be null");
            this.nullValueSerializer = nullValueSerializer;
            return this;
        }

        public GenericJackson2JsonRedisSerializerBuilder registerNullValueSerializer(boolean registerNullValueSerializer) {
            this.registerNullValueSerializer = registerNullValueSerializer;
            return this;
        }

        public GenericJackson2JsonRedisSerializer build() {
            boolean providedObjectMapper;
            ObjectMapper objectMapper = this.objectMapper;
            boolean bl = providedObjectMapper = objectMapper != null;
            if (objectMapper == null) {
                objectMapper = new ObjectMapper();
            }
            if (this.registerNullValueSerializer) {
                objectMapper.registerModule((Module)new SimpleModule("GenericJackson2JsonRedisSerializerBuilder").addSerializer((JsonSerializer)(this.nullValueSerializer != null ? this.nullValueSerializer : new NullValueSerializer(this.typeHintPropertyName))));
            }
            if (!providedObjectMapper && (this.defaultTyping == null || this.defaultTyping.booleanValue()) || this.defaultTyping != null && this.defaultTyping.booleanValue()) {
                objectMapper.setDefaultTyping((com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder)GenericJackson2JsonRedisSerializer.createDefaultTypeResolverBuilder(objectMapper, this.typeHintPropertyName));
            }
            return new GenericJackson2JsonRedisSerializer(objectMapper, this.reader, this.writer, this.typeHintPropertyName);
        }
    }

    private static class NullValueSerializer
    extends StdSerializer<NullValue> {
        private static final long serialVersionUID = 1999052150548658808L;
        private final String classIdentifier;

        NullValueSerializer(@Nullable String classIdentifier) {
            super(NullValue.class);
            this.classIdentifier = StringUtils.hasText((String)classIdentifier) ? classIdentifier : "@class";
        }

        public void serialize(NullValue value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(this.classIdentifier, NullValue.class.getName());
            jsonGenerator.writeEndObject();
        }

        public void serializeWithType(NullValue value, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            this.serialize(value, jsonGenerator, serializers);
        }
    }
}

