/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class DefaultRedisElementWriter<T>
implements RedisElementWriter<T> {
    @Nullable
    private final RedisSerializer<T> serializer;

    DefaultRedisElementWriter(RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public ByteBuffer write(@Nullable T value) {
        if (this.serializer != null && (value == null || this.serializer.canSerialize(value.getClass()))) {
            byte[] serializedValue = this.serializer.serialize(value);
            return serializedValue != null ? ByteBuffer.wrap(serializedValue) : ByteBuffer.wrap(new byte[0]);
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        throw new IllegalStateException("Cannot serialize value of type %s without a serializer".formatted(ObjectUtils.nullSafeClassName(value)));
    }
}

