/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.Message;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultMessage
implements Message {
    private static final byte[] EMPTY = new byte[0];
    private final byte[] channel;
    private final byte[] body;
    @Nullable
    private String toString;

    public DefaultMessage(byte[] channel, byte[] body) {
        Assert.notNull((Object)channel, (String)"Channel must not be null!");
        Assert.notNull((Object)body, (String)"Body must not be null!");
        this.body = body;
        this.channel = channel;
    }

    @Override
    public byte[] getChannel() {
        return this.channel.length == 0 ? EMPTY : (byte[])this.channel.clone();
    }

    @Override
    public byte[] getBody() {
        return this.body.length == 0 ? EMPTY : (byte[])this.body.clone();
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new String(this.body);
        }
        return this.toString;
    }
}

