/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapper {
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private static final String N_OR_PATTERN = "\\$.*or";
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter);
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        if (Keyword.isKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        BasicDBObject result = new BasicDBObject();
        for (String key : query.keySet()) {
            MongoPersistentProperty targetProperty = this.getTargetProperty(key, entity);
            String newKey = this.determineKey(key, entity);
            Object value = query.get(key);
            result.put(newKey, this.getMappedValue(value, targetProperty, newKey));
        }
        return result;
    }

    private DBObject getMappedKeyword(Keyword query, MongoPersistentEntity<?> entity) {
        if (query.key.matches(N_OR_PATTERN)) {
            Iterable conditions = (Iterable)query.value;
            BasicDBList newConditions = new BasicDBList();
            for (Object condition : conditions) {
                newConditions.add((Object)this.getMappedObject((DBObject)condition, entity));
            }
            return new BasicDBObject(query.key, (Object)newConditions);
        }
        return new BasicDBObject(query.key, this.convertSimpleOrDBObject(query.value, entity));
    }

    public DBObject getMappedKeyword(Keyword keyword, MongoPersistentProperty property) {
        if (property.isAssociation()) {
            this.convertAssociation(keyword.value, property);
        }
        return new BasicDBObject(keyword.key, this.getMappedValue(keyword.value, property, keyword.key));
    }

    private Object getMappedValue(Object source, MongoPersistentProperty property, String newKey) {
        if (property == null) {
            return this.convertSimpleOrDBObject(source, null);
        }
        if (property.isIdProperty() || "_id".equals(newKey)) {
            if (source instanceof DBObject) {
                DBObject valueDbo = (DBObject)source;
                if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                    String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get(inKey)) {
                        ids.add(this.convertId(id));
                    }
                    valueDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                } else if (valueDbo.containsField("$ne")) {
                    valueDbo.put("$ne", this.convertId(valueDbo.get("$ne")));
                } else {
                    return this.getMappedObject((DBObject)source, null);
                }
                return valueDbo;
            }
            return this.convertId(source);
        }
        if (property.isAssociation()) {
            return Keyword.isKeyword(source) ? this.getMappedKeyword(new Keyword(source), property) : this.convertAssociation(source, property);
        }
        return this.convertSimpleOrDBObject(source, (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property));
    }

    private MongoPersistentProperty getTargetProperty(String key, MongoPersistentEntity<?> entity) {
        if (this.isIdKey(key, entity)) {
            return (MongoPersistentProperty)entity.getIdProperty();
        }
        PersistentPropertyPath<MongoPersistentProperty> path = this.getPath(key, entity);
        return path == null ? null : (MongoPersistentProperty)path.getLeafProperty();
    }

    private PersistentPropertyPath<MongoPersistentProperty> getPath(String key, MongoPersistentEntity<?> entity) {
        if (entity == null) {
            return null;
        }
        try {
            PropertyPath path = PropertyPath.from((String)key, (TypeInformation)entity.getTypeInformation());
            return this.mappingContext.getPersistentPropertyPath(path);
        }
        catch (PropertyReferenceException e) {
            return null;
        }
    }

    private String determineKey(String key, MongoPersistentEntity<?> entity) {
        if (entity == null && DEFAULT_ID_NAMES.contains(key)) {
            return "_id";
        }
        PersistentPropertyPath<MongoPersistentProperty> path = this.getPath(key, entity);
        return path == null ? key : path.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE);
    }

    private Object convertSimpleOrDBObject(Object source, MongoPersistentEntity<?> entity) {
        if (source instanceof BasicDBList) {
            return this.converter.convertToMongoType(source);
        }
        if (source instanceof DBObject) {
            return this.getMappedObject((DBObject)source, entity);
        }
        return this.converter.convertToMongoType(source);
    }

    private Object convertAssociation(Object source, MongoPersistentProperty property) {
        if (property == null || !property.isAssociation()) {
            return source;
        }
        if (source instanceof Iterable) {
            BasicDBList result = new BasicDBList();
            for (Object element : (Iterable)source) {
                result.add(element instanceof DBRef ? element : this.converter.toDBRef(element, property));
            }
            return result;
        }
        return source == null || source instanceof DBRef ? source : this.converter.toDBRef(source, property);
    }

    private boolean isIdKey(String key, MongoPersistentEntity<?> entity) {
        if (entity == null) {
            return false;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return idProperty.getName().equals(key) || idProperty.getFieldName().equals(key);
        }
        return DEFAULT_ID_NAMES.contains(key);
    }

    public Object convertId(Object id) {
        try {
            return this.conversionService.convert(id, ObjectId.class);
        }
        catch (ConversionException conversionException) {
            return this.converter.convertToMongoType(id);
        }
    }

    private static class Keyword {
        String key;
        Object value;

        Keyword(Object source) {
            Assert.isInstanceOf(DBObject.class, (Object)source);
            DBObject value = (DBObject)source;
            Assert.isTrue((value.keySet().size() == 1 ? 1 : 0) != 0, (String)"Keyword must have a single key only!");
            this.key = (String)value.keySet().iterator().next();
            this.value = value.get(this.key);
        }

        static boolean isKeyword(Object value) {
            if (!(value instanceof DBObject)) {
                return false;
            }
            DBObject dbObject = (DBObject)value;
            return dbObject.keySet().size() == 1 && ((String)dbObject.keySet().iterator().next()).startsWith("$");
        }
    }
}

