/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.WriteConcernPropertyEditor;
import org.springframework.data.mongodb.core.MongoOptionsFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class MongoParsingUtils {
    private MongoParsingUtils() {
    }

    static void parseReplicaSet(Element element, BeanDefinitionBuilder mongoBuilder) {
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"replica-set", (String)"replicaSetSeeds");
    }

    static boolean parseMongoOptions(Element element, BeanDefinitionBuilder mongoBuilder) {
        Element optionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"options");
        if (optionsElement == null) {
            return false;
        }
        BeanDefinitionBuilder optionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoOptionsFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"connections-per-host", (String)"connectionsPerHost");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"threads-allowed-to-block-for-connection-multiplier", (String)"threadsAllowedToBlockForConnectionMultiplier");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"max-wait-time", (String)"maxWaitTime");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"connect-timeout", (String)"connectTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"socket-timeout", (String)"socketTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"socket-keep-alive", (String)"socketKeepAlive");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"auto-connect-retry", (String)"autoConnectRetry");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"max-auto-connect-retry-time", (String)"maxAutoConnectRetryTime");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"write-number", (String)"writeNumber");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"write-timeout", (String)"writeTimeout");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"write-fsync", (String)"writeFsync");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)optionsDefBuilder, (Element)optionsElement, (String)"slave-ok", (String)"slaveOk");
        mongoBuilder.addPropertyValue("mongoOptions", (Object)optionsDefBuilder.getBeanDefinition());
        return true;
    }

    static BeanDefinitionBuilder getWriteConcernPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.WriteConcern", WriteConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }
}

