/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.util.Assert;

class GeoCommandStatistics {
    private static final GeoCommandStatistics NONE = new GeoCommandStatistics((DBObject)new BasicDBObject());
    private final DBObject source;

    private GeoCommandStatistics(DBObject source) {
        Assert.notNull((Object)source, (String)"Source document must not be null!");
        this.source = source;
    }

    public static GeoCommandStatistics from(DBObject commandResult) {
        Assert.notNull((Object)commandResult, (String)"Command result must not be null!");
        Object stats = commandResult.get("stats");
        return stats == null ? NONE : new GeoCommandStatistics((DBObject)stats);
    }

    public double getAverageDistance() {
        Object averageDistance = this.source.get("avgDistance");
        return averageDistance == null ? Double.NaN : (Double)averageDistance;
    }
}

