/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappedConstructor {
    private static final String REJECT_CONSTRUCTOR = String.format("Entity doesn't have a usable constructor, either provide a custom converter or annotate a constructor with @%s!", PersistenceConstructor.class.getSimpleName());
    private final Set<MappedParameter> parameters;

    public MappedConstructor(MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) throws MappingException {
        Assert.notNull(entity);
        Assert.notNull(context);
        if (entity.getPreferredConstructor() == null) {
            throw new MappingException(REJECT_CONSTRUCTOR);
        }
        this.parameters = new HashSet<MappedParameter>();
        for (PreferredConstructor.Parameter parameter : entity.getPreferredConstructor().getParameters()) {
            this.parameters.add(new MappedParameter(parameter, entity, context));
        }
    }

    public boolean isConstructorParameter(PersistentProperty<?> property) {
        Assert.notNull(property);
        for (MappedParameter parameter : this.parameters) {
            if (!parameter.maps(property)) continue;
            return true;
        }
        return false;
    }

    public MappedParameter getFor(PreferredConstructor.Parameter<?> parameter) {
        for (MappedParameter mappedParameter : this.parameters) {
            if (!mappedParameter.parameter.equals(parameter)) continue;
            return mappedParameter;
        }
        throw new MappingException(String.format("Didn't find a MappedParameter for %s!", parameter.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MappedParameter {
        private final MongoPersistentProperty property;
        private final PreferredConstructor.Parameter<?> parameter;

        public MappedParameter(PreferredConstructor.Parameter<?> parameter, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, ? extends MongoPersistentProperty> context) {
            Assert.notNull(parameter);
            Assert.notNull(entity);
            Assert.notNull(context);
            this.parameter = parameter;
            PropertyPath propertyPath = PropertyPath.from((String)parameter.getName(), (Class)entity.getType());
            PersistentPropertyPath path = context.getPersistentPropertyPath(propertyPath);
            this.property = path == null ? null : (MongoPersistentProperty)path.getLeafProperty();
        }

        public boolean hasSpELExpression() {
            return this.parameter.getKey() != null;
        }

        public String getFieldName() {
            return this.property.getFieldName();
        }

        public TypeInformation<?> getPropertyTypeInformation() {
            return this.property.getTypeInformation();
        }

        public boolean maps(PersistentProperty<?> property) {
            return this.property.equals(property);
        }
    }
}

