/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.repository.Temporal;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;

public class JpaParameters
extends Parameters<JpaParameters, JpaParameter> {
    public JpaParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new JpaParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
    }

    protected JpaParameters(ParametersSource parametersSource, Function<MethodParameter, JpaParameter> parameterFactory) {
        super(parametersSource, parameterFactory);
    }

    JpaParameters(List<JpaParameter> parameters) {
        super(parameters);
    }

    protected JpaParameters createFrom(List<JpaParameter> parameters) {
        return new JpaParameters(parameters);
    }

    public boolean hasLimitingParameters() {
        return this.hasLimitParameter() || this.hasPageableParameter();
    }

    public static class JpaParameter
    extends Parameter {
        @Nullable
        private final Temporal annotation;
        @Nullable
        private TemporalType temporalType;

        protected JpaParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            this.annotation = (Temporal)parameter.getParameterAnnotation(Temporal.class);
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter");
            }
        }

        public boolean isBindable() {
            return super.isBindable() || this.isTemporalParameter();
        }

        boolean isTemporalParameter() {
            return this.isDateParameter() && this.hasTemporalParamAnnotation();
        }

        @Nullable
        TemporalType getTemporalType() {
            if (this.temporalType == null) {
                this.temporalType = this.annotation == null ? null : this.annotation.value();
            }
            return this.temporalType;
        }

        TemporalType getRequiredTemporalType() throws IllegalStateException {
            TemporalType temporalType = this.getTemporalType();
            if (temporalType != null) {
                return temporalType;
            }
            throw new IllegalStateException(String.format("Required temporal type not found for %s", this.getType()));
        }

        private boolean hasTemporalParamAnnotation() {
            return this.annotation != null;
        }

        private boolean isDateParameter() {
            return this.getType().equals(Date.class);
        }
    }
}

