/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.antlr.v4.runtime.tree.ParseTree;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryRenderer;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.jpa.repository.query.QueryTransformers;

class EqlCountQueryTransformer
extends EqlQueryRenderer {
    @Nullable
    private final String countProjection;
    @Nullable
    private final String primaryFromAlias;

    EqlCountQueryTransformer(@Nullable String countProjection, QueryInformation queryInformation) {
        this.countProjection = countProjection;
        this.primaryFromAlias = queryInformation.getAlias();
    }

    @Override
    public QueryTokenStream visitSelect_statement(EqlParser.Select_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        boolean usesDistinct = ctx.DISTINCT() != null;
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        builder.append(QueryTokens.TOKEN_COUNT_FUNC);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (this.countProjection == null) {
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
                nested.append(this.getDistinctCountSelection(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((EqlCountQueryTransformer)this).visit(arg_0), QueryTokens.TOKEN_COMMA)));
            } else {
                nested.append(QueryTokens.token(this.primaryFromAlias));
            }
        } else {
            builder.append(QueryTokens.token(this.countProjection));
            if (usesDistinct) {
                nested.append(QueryTokens.expression(ctx.DISTINCT()));
            }
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    private QueryTokenStream getDistinctCountSelection(QueryTokenStream selectionListbuilder) {
        QueryRenderer.QueryRendererBuilder nested = new QueryRenderer.QueryRendererBuilder();
        QueryTransformers.CountSelectionTokenStream countSelection = QueryTransformers.CountSelectionTokenStream.create(selectionListbuilder);
        if (countSelection.requiresPrimaryAlias()) {
            if (this.primaryFromAlias == null) {
                throw new IllegalStateException("Primary alias must be set for DISTINCT count selection using constructor expressions");
            }
            nested.append(QueryTokens.token(this.primaryFromAlias));
        } else {
            nested.append(countSelection);
        }
        return nested;
    }
}

