/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.util.List;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.PreprocessedQuery;

class NamedAotQuery
extends AotQuery {
    private final String name;
    private final DeclaredQuery query;

    private NamedAotQuery(String name, DeclaredQuery queryString, List<ParameterBinding> parameterBindings) {
        super(parameterBindings);
        this.name = name;
        this.query = queryString;
    }

    public static NamedAotQuery named(String namedQuery, DeclaredQuery queryString) {
        PreprocessedQuery parsed = PreprocessedQuery.parse(queryString);
        return new NamedAotQuery(namedQuery, queryString, parsed.getBindings());
    }

    public String getName() {
        return this.name;
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.getQuery().getQueryString();
    }

    @Override
    public boolean isNative() {
        return this.query.isNative();
    }
}

