/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JSqlParserUtils;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.util.Predicates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SerializationUtils;
import org.springframework.util.StringUtils;

public class JSqlParserQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;
    private final Statement statement;
    private final ParsedType parsedType;
    private final boolean hasConstructorExpression;
    @Nullable
    private final String primaryAlias;
    private final String projection;
    private final Set<String> joinAliases;
    private final Set<String> selectAliases;
    private final byte[] serialized;

    public JSqlParserQueryEnhancer(DeclaredQuery query) {
        this.query = query;
        this.statement = JSqlParserQueryEnhancer.parseStatement(query.getQueryString(), Statement.class);
        this.parsedType = JSqlParserQueryEnhancer.detectParsedType(this.statement);
        this.hasConstructorExpression = QueryUtils.hasConstructorExpression(query.getQueryString());
        this.primaryAlias = JSqlParserQueryEnhancer.detectAlias(this.parsedType, this.statement);
        this.projection = JSqlParserQueryEnhancer.detectProjection(this.statement);
        this.selectAliases = Collections.unmodifiableSet(JSqlParserQueryEnhancer.getSelectionAliases(this.statement));
        this.joinAliases = Collections.unmodifiableSet(JSqlParserQueryEnhancer.getJoinAliases(this.statement));
        this.serialized = SerializationUtils.serialize((Object)this.statement);
    }

    static <T extends Statement> T parseStatement(String sql, Class<T> classOfT) {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((String)sql);
            boolean allowComplex = parser.getConfiguration().getAsBoolean(Feature.allowComplexParsing);
            try {
                return (T)((Statement)classOfT.cast(((CCJSqlParser)parser.withAllowComplexParsing(true)).Statement()));
            }
            catch (ParseException ex) {
                if (allowComplex && CCJSqlParserUtil.getNestingDepth((String)sql) <= 10) {
                    parser = CCJSqlParserUtil.newParser((String)sql);
                    return (T)((Statement)classOfT.cast(((CCJSqlParser)parser.withAllowComplexParsing(true)).Statement()));
                }
                throw ex;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The query you provided is not a valid SQL Query", e);
        }
    }

    @Nullable
    private static String detectAlias(ParsedType parsedType, Statement statement) {
        if (ParsedType.MERGE.equals((Object)parsedType)) {
            Merge mergeStatement = (Merge)statement;
            Alias alias = mergeStatement.getUsingAlias();
            return alias == null ? null : alias.getName();
        }
        if (ParsedType.SELECT.equals((Object)parsedType)) {
            return JSqlParserQueryEnhancer.doWithPlainSelect(statement, it -> it.getFromItem() == null || it.getFromItem().getAlias() == null, it -> it.getFromItem().getAlias().getName(), () -> null);
        }
        return null;
    }

    private static Set<String> getSelectionAliases(Statement statement) {
        if (statement instanceof SetOperationList) {
            SetOperationList sel = (SetOperationList)statement;
            statement = sel.getSelect(0);
        }
        return JSqlParserQueryEnhancer.doWithPlainSelect(statement, it -> CollectionUtils.isEmpty((Collection)it.getSelectItems()), it -> {
            HashSet<String> set = new HashSet<String>(it.getSelectItems().size(), 1.0f);
            for (SelectItem selectItem : it.getSelectItems()) {
                Alias alias = selectItem.getAlias();
                if (alias == null) continue;
                set.add(alias.getName());
            }
            return set;
        }, Collections::emptySet);
    }

    private static Set<String> getJoinAliases(Statement statement) {
        if (statement instanceof SetOperationList) {
            SetOperationList sel = (SetOperationList)statement;
            statement = sel.getSelect(0);
        }
        return JSqlParserQueryEnhancer.doWithPlainSelect(statement, it -> CollectionUtils.isEmpty((Collection)it.getJoins()), it -> {
            HashSet<String> set = new HashSet<String>(it.getJoins().size(), 1.0f);
            for (Join join : it.getJoins()) {
                Alias alias = join.getRightItem().getAlias();
                if (alias == null) continue;
                set.add(alias.getName());
            }
            return set;
        }, Collections::emptySet);
    }

    private static <T> T doWithPlainSelect(Statement statement, Function<PlainSelect, T> mapper, Supplier<T> fallback) {
        Predicate neverSkip = Predicates.isFalse();
        return JSqlParserQueryEnhancer.doWithPlainSelect(statement, neverSkip, mapper, fallback);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T doWithPlainSelect(Statement statement, Predicate<PlainSelect> skipIf, Function<PlainSelect, T> mapper, Supplier<T> fallback) {
        void select;
        if (!(statement instanceof Select)) {
            return fallback.get();
        }
        Select select2 = (Select)statement;
        try {
            if (skipIf.test(select.getPlainSelect())) {
                return fallback.get();
            }
        }
        catch (ClassCastException classCastException) {
            return fallback.get();
        }
        return mapper.apply(select.getPlainSelect());
    }

    /*
     * WARNING - void declaration
     */
    private static String detectProjection(Statement statement) {
        void select;
        if (!(statement instanceof Select)) {
            return "";
        }
        Select select2 = (Select)statement;
        if (select instanceof Values) {
            return "";
        }
        Select selectBody = select;
        if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            selectBody = (Select)setOperationList.getSelects().get(0);
        }
        return JSqlParserQueryEnhancer.doWithPlainSelect((Statement)selectBody, it -> CollectionUtils.isEmpty((Collection)it.getSelectItems()), it -> {
            StringJoiner joiner = new StringJoiner(", ");
            for (SelectItem selectItem : it.getSelectItems()) {
                joiner.add(selectItem.toString());
            }
            return joiner.toString().trim();
        }, () -> "");
    }

    private static ParsedType detectParsedType(Statement statement) {
        if (statement instanceof Insert) {
            return ParsedType.INSERT;
        }
        if (statement instanceof Update) {
            return ParsedType.UPDATE;
        }
        if (statement instanceof Delete) {
            return ParsedType.DELETE;
        }
        if (statement instanceof Select) {
            return ParsedType.SELECT;
        }
        if (statement instanceof Merge) {
            return ParsedType.MERGE;
        }
        return ParsedType.OTHER;
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    public String detectAlias() {
        return this.primaryAlias;
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public Set<String> getJoinAliases() {
        return this.joinAliases;
    }

    public Set<String> getSelectionAliases() {
        return this.selectAliases;
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }

    @Override
    public String applySorting(Sort sort) {
        return this.doApplySorting(sort, this.detectAlias());
    }

    @Override
    public String rewrite(QueryEnhancer.QueryRewriteInformation rewriteInformation) {
        return this.doApplySorting(rewriteInformation.getSort(), this.primaryAlias);
    }

    @Override
    public String applySorting(Sort sort, @Nullable String alias) {
        return this.doApplySorting(sort, alias);
    }

    private String doApplySorting(Sort sort, @Nullable String alias) {
        String queryString = this.query.getQueryString();
        Assert.hasText((String)queryString, (String)"Query must not be null or empty");
        if (this.parsedType != ParsedType.SELECT || sort.isUnsorted()) {
            return queryString;
        }
        return this.applySorting((Select)JSqlParserQueryEnhancer.deserialize(this.serialized), sort, alias);
    }

    private String applySorting(Select selectStatement, Sort sort, @Nullable String alias) {
        if (selectStatement instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectStatement;
            return JSqlParserQueryEnhancer.applySortingToSetOperationList(setOperationList, sort);
        }
        JSqlParserQueryEnhancer.doWithPlainSelect((Statement)selectStatement, it -> {
            ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(16);
            for (Sort.Order order : sort) {
                orderByElements.add(JSqlParserQueryEnhancer.getOrderClause(this.joinAliases, this.selectAliases, alias, order));
            }
            if (CollectionUtils.isEmpty((Collection)it.getOrderByElements())) {
                it.setOrderByElements(orderByElements);
            } else {
                it.getOrderByElements().addAll(orderByElements);
            }
            return null;
        }, () -> "");
        return selectStatement.toString();
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        if (this.parsedType != ParsedType.SELECT) {
            return this.query.getQueryString();
        }
        Assert.hasText((String)this.query.getQueryString(), (String)"OriginalQuery must not be null or empty");
        Statement statement = (Statement)JSqlParserQueryEnhancer.deserialize(this.serialized);
        return JSqlParserQueryEnhancer.doWithPlainSelect(statement, it -> JSqlParserQueryEnhancer.createCountQueryFor(it, countProjection, this.primaryAlias), this.query::getQueryString);
    }

    private static String createCountQueryFor(PlainSelect selectBody, @Nullable String countProjection, @Nullable String primaryAlias) {
        selectBody.setOrderByElements(null);
        if (StringUtils.hasText((String)countProjection)) {
            selectBody.setSelectItems(Collections.singletonList(SelectItem.from((Expression)JSqlParserUtils.getJSqlCount(Collections.singletonList(countProjection), false))));
        } else {
            boolean distinct = selectBody.getDistinct() != null;
            selectBody.setDistinct(null);
            net.sf.jsqlparser.expression.Function jSqlCount = JSqlParserUtils.getJSqlCount(Collections.singletonList(JSqlParserQueryEnhancer.countPropertyNameForSelection(selectBody.getSelectItems(), distinct, primaryAlias)), distinct);
            selectBody.setSelectItems(Collections.singletonList(SelectItem.from((Expression)jSqlCount)));
        }
        return selectBody.toString();
    }

    private static String applySortingToSetOperationList(SetOperationList setOperationListStatement, Sort sort) {
        for (Select select : setOperationListStatement.getSelects()) {
            if (!(select instanceof Values)) continue;
            return setOperationListStatement.toString();
        }
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(16);
        for (Sort.Order order : sort) {
            orderByElements.add(JSqlParserQueryEnhancer.getOrderClause(Collections.emptySet(), Collections.emptySet(), null, order));
        }
        if (setOperationListStatement.getOrderByElements() == null) {
            setOperationListStatement.setOrderByElements(orderByElements);
        } else {
            setOperationListStatement.getOrderByElements().addAll(orderByElements);
        }
        return setOperationListStatement.toString();
    }

    private static OrderByElement getOrderClause(Set<String> joinAliases, Set<String> selectionAliases, @Nullable String alias, Sort.Order order) {
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setAsc(order.getDirection().isAscending());
        orderByElement.setAscDescPresent(true);
        String property = order.getProperty();
        QueryUtils.checkSortExpression(order);
        if (selectionAliases.contains(property)) {
            net.sf.jsqlparser.expression.Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(property) : new Column(property);
            orderByElement.setExpression((Expression)orderExpression);
            return orderByElement;
        }
        boolean qualifyReference = true;
        for (String joinAlias : joinAliases) {
            if (!property.startsWith(joinAlias.concat("."))) continue;
            qualifyReference = false;
            break;
        }
        boolean functionIndicator = property.contains("(");
        String reference = qualifyReference && !functionIndicator && StringUtils.hasText((String)alias) ? alias + "." + property : property;
        net.sf.jsqlparser.expression.Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(reference) : new Column(reference);
        orderByElement.setExpression((Expression)orderExpression);
        switch (order.getNullHandling()) {
            case NULLS_FIRST: {
                orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
                break;
            }
            case NULLS_LAST: {
                orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
                break;
            }
        }
        return orderByElement;
    }

    private static String countPropertyNameForSelection(List<SelectItem<?>> selectItems, boolean distinct, @Nullable String tableAlias) {
        if (JSqlParserQueryEnhancer.onlyASingleColumnProjection(selectItems)) {
            SelectItem<?> singleProjection = selectItems.get(0);
            Column column = (Column)singleProjection.getExpression();
            return column.getFullyQualifiedName();
        }
        return distinct ? (String)(tableAlias != null ? tableAlias + "." : "") + "*" : "1";
    }

    private static boolean onlyASingleColumnProjection(List<SelectItem<?>> projection) {
        return projection.size() == 1 && projection.get(0) instanceof SelectItem && projection.get(0).getExpression() instanceof Column;
    }

    private static Object deserialize(byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                return ois.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to deserialize object", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to deserialize object type", ex);
        }
    }

    static enum ParsedType {
        DELETE,
        UPDATE,
        SELECT,
        INSERT,
        MERGE,
        OTHER;

    }
}

