/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.kafka;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.SpringKafkaConsumerPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.SpringKafkaProducerPostProcessor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ProducerFactory;

public class SpringKafkaFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public SpringKafkaFactoryBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ProducerFactory factory;
        if (bean instanceof ConsumerFactory) {
            ConsumerFactory factory2 = (ConsumerFactory)bean;
            if (factory2.getPostProcessors().stream().noneMatch(o -> o instanceof SpringKafkaConsumerPostProcessor)) {
                factory2.addPostProcessor(new SpringKafkaConsumerPostProcessor(this.beanFactory));
            }
        } else if (bean instanceof ProducerFactory && (factory = (ProducerFactory)bean).getPostProcessors().stream().noneMatch(o -> o instanceof SpringKafkaProducerPostProcessor)) {
            factory.addPostProcessor(new SpringKafkaProducerPostProcessor(this.beanFactory));
        }
        return bean;
    }
}

