/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.SpringKafkaFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaAspect;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.ProducerFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ProducerFactory.class})
@ConditionalOnMissingClass(value={"brave.kafka.clients.KafkaTracing"})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.kafka.enabled"}, matchIfMissing=true)
public class SpringKafkaAutoConfiguration {
    @Bean
    static SpringKafkaFactoryBeanPostProcessor springKafkaFactoryBeanPostProcessor(BeanFactory beanFactory) {
        return new SpringKafkaFactoryBeanPostProcessor(beanFactory);
    }

    @Bean
    TracingKafkaAspect tracingKafkaAspect(Tracer tracer, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        return new TracingKafkaAspect(tracer, propagator, extractor);
    }
}

