/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.opentracing;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import io.opentracing.Tracer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthOpentracingProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.opentracing.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnClass(value={Tracer.class, BraveTracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthOpentracingProperties.class})
public class BraveOpentracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"brave.opentracing.BraveTracer"})
    Tracer sleuthOpenTracing(Tracing braveTracing) {
        return BraveTracer.create((Tracing)braveTracing);
    }
}

