/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.docs;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpanAssertions;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.ImmutableAssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.TagKey;

public interface AssertingSpanBuilder
extends Span.Builder {
    public DocumentedSpan getDocumentedSpan();

    public Span.Builder getDelegate();

    @Override
    default public AssertingSpanBuilder tag(String key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key, value);
        return this;
    }

    default public AssertingSpanBuilder tag(TagKey key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key.getKey(), value);
        return this;
    }

    @Override
    default public AssertingSpanBuilder event(String value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value);
        return this;
    }

    default public AssertingSpanBuilder event(EventValue value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value.getValue());
        return this;
    }

    @Override
    default public AssertingSpanBuilder name(String name) {
        DocumentedSpanAssertions.assertThatNameIsValid(name, this.getDocumentedSpan());
        this.getDelegate().name(name);
        return this;
    }

    @Override
    default public AssertingSpanBuilder error(Throwable throwable) {
        this.getDelegate().error(throwable);
        return this;
    }

    @Override
    default public AssertingSpanBuilder remoteServiceName(String remoteServiceName) {
        this.getDelegate().remoteServiceName(remoteServiceName);
        return this;
    }

    @Override
    default public Span.Builder remoteIpAndPort(String ip, int port) {
        this.getDelegate().remoteIpAndPort(ip, port);
        return this;
    }

    @Override
    default public AssertingSpanBuilder setParent(TraceContext context) {
        this.getDelegate().setParent(context);
        return this;
    }

    @Override
    default public AssertingSpanBuilder setNoParent() {
        this.getDelegate().setNoParent();
        return this;
    }

    @Override
    default public AssertingSpanBuilder kind(Span.Kind spanKind) {
        this.getDelegate().kind(spanKind);
        return this;
    }

    @Override
    default public AssertingSpan start() {
        final Span span = this.getDelegate().start();
        final DocumentedSpan documentedSpan = this.getDocumentedSpan();
        return new AssertingSpan(){

            @Override
            public DocumentedSpan getDocumentedSpan() {
                return documentedSpan;
            }

            @Override
            public Span getDelegate() {
                return span;
            }

            @Override
            public boolean isStarted() {
                return true;
            }

            public String toString() {
                return this.getDelegate().toString();
            }
        };
    }

    public static AssertingSpanBuilder of(DocumentedSpan documentedSpan, Span.Builder builder) {
        if (builder == null) {
            return null;
        }
        if (builder instanceof AssertingSpanBuilder) {
            return (AssertingSpanBuilder)builder;
        }
        return new ImmutableAssertingSpanBuilder(documentedSpan, builder);
    }
}

